package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsNowItemDao;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2020/4/19 17:44
 **/
@Component("rightsNowItemDao")
public class RightsNowItemDaoImpl  extends BaseDaoImpl<RightsNowItem> implements RightsNowItemDao {
    @Override
    public Integer batchInsert(List<RightsNowItem> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"),list);
    }

    @Override
    public void deleteByRightsSettingId(Long rightsSettingId) {
        super.getSqlSession().delete(getStatement("deleteByRightsSettingId"),rightsSettingId);
    }

    @Override
    public List<RightsNowItem> getListByRightsSettingId(Long rightsSettingId,List<Integer> types) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("types",types);
        return super.getSqlSession().selectList(getStatement("getListByRightsSettingId"),map);
    }

    @Override
    public List<RightsNowItem> getGiftCouponListByRightsSettingId(Long rightsSettingId) {
        Map<String,Object> map=new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        return super.getSqlSession().selectList(getStatement("getGiftCouponListByRightsSettingId"),map);
    }

    @Override
    public List<RightsNowItem> getListByGroupIds(List<Long> groupIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("groupIds",groupIds);
        return super.getSqlSession().selectList(getStatement("getListByGroupIds"),map);
    }
}
