package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.skill.dao.PcloudGroupActivityDao;
import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.book.skill.facade.response.QueryGroupActivityResponseVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import java.util.HashMap;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class PcloudGroupActivityDaoImpl extends BaseDaoImpl<PcloudGroupActivity> implements PcloudGroupActivityDao {

    @Override
    public Map<Long, PcloudGroupActivity> mayByIds(List<Long> ids) {
        return super.getSqlSession().selectMap(getStatement("mayByIds"), ids,"id");
    }

    @Override
    public void updateByPrimaryKeySelective(PcloudGroupActivity entity) {
        this.getSqlSession().update("com.pcloud.book.skill.dao.impl.PcloudGroupActivityDaoImpl.updateByPrimaryKeySelective", entity);
    }

    @Override
    public GroupActivity4AppletDTO getGroupActivity4Applet(Long firstClassify,Long secondClassify,Long gradeLabelId,Long subjectLabelId) {
        Map<String, Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("gradeLabelId", gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        return super.getSqlSession().selectOne(getStatement("getGroupActivity4Applet"), map);
    }

    @Override
    public List<GroupActivity4AppletDTO> getTishBookSchoolList(BaseTempletClassify baseTempletClassify) {
        return super.getSqlSession().selectList(getStatement("getTishBookSchoolList"), baseTempletClassify);
    }

}
