package com.pcloud.book.timecontrol.biz;

import com.pcloud.book.group.dto.UserSelectParamDTO;
import com.pcloud.book.timecontrol.dto.SelfPlanUserDto;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlan;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlanFeedback;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlanItem;
import com.pcloud.book.timecontrol.vo.AddTask4SelfPlan;
import com.pcloud.book.timecontrol.vo.CreateSelfPlanVO;
import com.pcloud.book.timecontrol.vo.SelfPlanVO;
import com.pcloud.book.timecontrol.vo.UpdateSelfPlanVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface SelfPlanBiz {

    Integer createSelfPlan(CreateSelfPlanVO createSelfPlanVO);

    void addTask4SelfPlan(AddTask4SelfPlan addTask4SelfPlan);

    PageBeanNew<SelfPlanVO> listSelfPlan(Integer currentPage, Integer numPerPage, Integer serviceState);

    void deleteSelfPlan(Integer planId);

    void editSelfPlanItems(List<TimeControlSelfPlanItem> selfPlanItemList);

    List<TimeControlSelfPlanItem> getSelfPlanItems(Integer planId);

    List<TimeControlSelfPlanItem> getSelfPlanItems4Wechat(Integer planId);

    void commitFeedback(List<TimeControlSelfPlanFeedback> selfPlanFeedbackList);

    List<TimeControlSelfPlanFeedback> getFeedbackByPlan(Integer planId);

    void commitEvaluate(TimeControlSelfPlanFeedback selfPlanFeedback);

    PageBeanNew<SelfPlanUserDto> listUser4SelfPlan(UserSelectParamDTO userSelectParamDTO);

    void payBack(Integer planId);

    void advancedSetting(TimeControlSelfPlan timeControlSelfPlan);

    void updateSelfPlan(UpdateSelfPlanVO updateSelfPlanVO);

    TimeControlSelfPlan getSelfPlanById(Integer planId);

    PageBeanNew<TimeControlSelfPlanFeedback> getFeedbackPage(Integer planId, Integer currentPage, Integer numPerPage);

    TimeControlSelfPlan getLatestPlan(String wxId, Integer planId);
}
