package com.pcloud.book.timecontrol.biz;

import com.pcloud.book.timecontrol.dto.BookTaskBindingDto;
import com.pcloud.book.timecontrol.dto.CreateTaskDto;
import com.pcloud.book.timecontrol.dto.CreateTaskItemDto;
import com.pcloud.book.timecontrol.dto.LabelDto;
import com.pcloud.book.timecontrol.dto.ReplyMessageBaseDto;
import com.pcloud.book.timecontrol.dto.TaskDto;
import com.pcloud.book.timecontrol.dto.TaskItemDto;
import com.pcloud.book.timecontrol.dto.UpdateTaskDto;
import com.pcloud.book.timecontrol.dto.UpdateTaskItemDto;
import com.pcloud.book.timecontrol.entity.TimeControlReplyMessage;
import com.pcloud.book.timecontrol.entity.TimeControlTask;
import com.pcloud.book.timecontrol.vo.KeyWordTaskVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * @Description：TODO
 * @Author：zcy
 * @Date：2020-01-30
 * @Version：1.0
 */
public interface TaskBiz {

    Integer createTask(CreateTaskDto createTaskDto);

    void deleteTask(Integer taskId);

    void updateTask(UpdateTaskDto updateTaskDto);

    TaskDto getTaskById(Integer taskId);

    PageBeanNew<TaskDto> listTask4Pcloud(Integer currentPage, Integer numPerPage, String search);

    Integer createTaskItem(CreateTaskItemDto createTaskItemDto);

    void deleteTaskItem(Integer id);

    void updateTaskItem(UpdateTaskItemDto updateTaskItemDto);

    TaskItemDto getTaskItem(Integer id);

    List<ReplyMessageBaseDto> listTaskItemDay(Integer taskId);

    List<BookTaskBindingDto> listTask(String search);

    List<KeyWordTaskVO> listKeyWordTask();

    TaskDto getTaskByKey(String search, String wxUserId);

    List<LabelDto> listMaxDepLabel(Integer num);

    List<TaskDto> listTaskByKey4User(String wxUserId, String search);

    List<TaskDto> listTaskByIds4User(String wxUserId, List<Integer> taskIds);

    List<TaskDto> listTaskByLabelIds4User(String wxUserId, Long labelId);

    void finishTaskSend(Integer taskSendId);

    TaskDto getTaskByIdAndWxUserId(Integer relSkillId, String wxUserId);

    void sendReplyMessage(List<TimeControlReplyMessage> replyMessages, String wxUserId, String robotWxId, String ip);

    Integer copyTaskItem(Integer taskItemId);

    void addTask4TimeControl();

    void updateSendState4Week();

    void updateTaskSendType(TimeControlTask taskDto);
}
