package com.pcloud.book.timecontrol.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlanFeedback;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class SelfPlanVO implements Serializable {

    private Integer planId;

    private String robotWxId;

    @ApiModelProperty("个人号类型")
    private Integer robotType;

    @ApiModelProperty("分类名称")
    private String classifyName;

    private String wxId;

    private String nickName;

    private String headUrl;

    private Integer taskId;

    private BigDecimal totalPrice;

    private Integer evaluateOpen;

    private Integer serviceState;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String linkUrl;

    private Integer feedbackState;

    //意见反馈
    private List<TimeControlSelfPlanFeedback> timeControlSelfPlanFeedback4Suggestion;

    //评分
    private TimeControlSelfPlanFeedback timeControlSelfPlanFeedback4Evaluate;

    @ApiModelProperty("编号")
    private String uniqueNumber;

}
