package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockCouponDao;
import com.pcloud.book.weixinclock.entity.WeixinClockCoupon;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @Describe: 微信群打卡优惠券dao实现层
 * @Author: zhangdongwei
 * @Date: Create on 11:19 2019/11/12 0012
 */
@Repository("weixinClockCouponDao")
public class WeixinClockCouponDaoImpl extends BaseDaoImpl<WeixinClockCoupon> implements WeixinClockCouponDao {
    @Override
    public WeixinClockCoupon getBaseById(Long id) {
        return super.sqlSessionTemplate.selectOne(getStatement("getBaseById"), id);
    }

    @Override
    public WeixinClockCoupon getBaseByClockId(Long weixinClockId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getBaseByClockId"), weixinClockId);
    }

    @Override
    public Map<Long, WeixinClockCoupon> getByClockIds(List<Long> clockIds) {
        return super.sqlSessionTemplate.selectMap(getStatement("getByClockIds"), clockIds, "weixinClockId");
    }
}
