package com.pcloud.book.weixinclock.dao.impl;

import com.google.common.collect.Maps;

import com.pcloud.book.weixinclock.dao.WeixinClockTopicDao;
import com.pcloud.book.weixinclock.entity.WeixinClockTopic;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.utils.DateNewUtils;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.Map;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/16 11:39
 */
@Repository("weixinClockTopicDao")
public class WeixinClockTopicDaoImpl extends BaseDaoImpl<WeixinClockTopic> implements WeixinClockTopicDao {

    /**
     * 获取用户今天打卡情况
     */
    @Override
    public WeixinClockTopic getTopicByIds4Today(String wxGroupId, String wxUserId) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("wxGroupId", wxGroupId);
        paramMap.put("wxUserId", wxUserId);
        paramMap.put("date", DateNewUtils.getShortDateStr());
        return super.getSqlSession().selectOne(getStatement("getTopicByIds4Today"), paramMap);
    }

    /**
     * 获得用户的打卡天数
     */
    @Override
    public Long getClockCountByUser(String wxGroupId, String wxUserId) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("wxGroupId", wxGroupId);
        paramMap.put("wxUserId", wxUserId);
        return super.getSqlSession().selectOne(getStatement("getClockCountByUser"), paramMap);
    }

    @Override
    public Date getFirstClockDay(String wxUserId, String wxGroupId) {
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("wxGroupId", wxGroupId);
        paramMap.put("wxUserId", wxUserId);
        return super.getSqlSession().selectOne(getStatement("getFirstClockDay"), paramMap);
    }

}
