package com.pcloud.book.weixinclock.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * @Describe: 群打卡优惠券entity
 * @Author: zhangdongwei
 * @Date: Create on 9:41 2019/11/11 0011
 */
@Data
public class WeixinClockCoupon extends BaseEntity {

    private Long weixinClockId;
    /**
     * 优惠券平台（淘宝、京东、当当）
     */
    private Integer couponPlatform;
    /**
     * 商品名称
     */
    private String title;
    /**
     * 商品图片
     */
    private String pictUrl;
    /**
     * 商品原始价格
     */
    private BigDecimal proOriginPrice;
    /**
     * 优惠券价格
     */
    private BigDecimal couponPrice;
    /**
     * 劵后价格
     */
    private BigDecimal afterCouponPrice;
    /**
     * 优惠券点击链接
     */
    private String couponClickUrl;

    /**
     * 领取优惠券的打卡天数
     */
    private Integer dayNum;

    private Long createUser;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    private Long updateUser;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;
}
