package com.pcloud.book.weixinclock.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.weixinclock.biz.WeixinClockPraiseBiz;
import com.pcloud.book.weixinclock.vo.request.PraiseForMemberRequestVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Describe: 微信打卡点赞外部接口实现
 * @Author: zhangdongwei
 * @Date: Create on 17:37 2019/10/22 0022
 */
@Api(description = "微信群签到打卡")
@RestController("weixinClockPraiseFacade")
@RequestMapping("weixinClockPraise")
public class WeixinClockPraiseFacadeImpl {
    @Autowired
    private WeixinClockPraiseBiz weixinClockPraiseBiz;

    /**
     * 为打卡成员点赞/取消点赞
     * @param userInfo
     * @param vo
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @ApiOperation(value = "为打卡成员点赞/取消点赞", httpMethod = "POST")
    @PostMapping("praiseForMember")
    public ResponseDto<?> praiseForMember(@CookieValue("userInfo") String userInfo, @RequestBody PraiseForMemberRequestVO vo) throws BizException, PermissionException {
        Optional.ofNullable(vo).orElseThrow(() -> new BookBizException(BookBizException.PARAM_IS_ERROR, "点赞失败，参数为空"));
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        vo.setPraiseUserId(wechatUserId);
        weixinClockPraiseBiz.praiseForMember(vo);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取点赞用户列表", httpMethod = "GET")
    @GetMapping("listPraiseUser")
    public ResponseDto<?> listPraiseUser(@CookieValue("userInfo") String userInfo,
                                         @RequestParam("wxGroupId") String wxGroupId,
                                         @RequestParam("wxUserId") String wxUserId,
                                         @RequestParam("currentPage") Integer currentPage,
                                         @RequestParam("numPerPage") Integer numPerPage) throws BizException, PermissionException {
        if (null == wxGroupId || null == wxUserId){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数为空");
        }
        PageParam pageParam = new PageParam(currentPage, numPerPage);
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(weixinClockPraiseBiz.listPraiseUser(wxGroupId, wxUserId, pageParam));
    }
}
