package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

/**
 * @描述：投放详情
 * @作者：zhuyajie
 * @创建时间：9:15 2019/7/17
 * @版本：1.0
 */
public class AdvertisingDistributionDTO extends BaseDto{

    private Long adId;
    /**
     * 投放时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date distributionTime;
    /**
     * 投放类型1:单次发送 2:每天发送 3:每周发送
     */
    private Integer putType;

    /**
     * 计划投放开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 计划投放结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 计划投放时间
     */
    private String putTime;

    /**
     * 周几
     */
    private Integer weekDay;

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public Integer getPutType() {
        return putType;
    }

    public void setPutType(Integer putType) {
        this.putType = putType;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getPutTime() {
        return putTime;
    }

    public void setPutTime(String putTime) {
        this.putTime = putTime;
    }

    public Integer getWeekDay() {
        return weekDay;
    }

    public void setWeekDay(Integer weekDay) {
        this.weekDay = weekDay;
    }

    @Override
    public String toString() {
        return "AdvertisingDistributionDTO{" +
                "adId=" + adId +
                ", distributionTime=" + distributionTime +
                ", putType=" + putType +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", putTime=" + putTime +
                ", weekDay=" + weekDay +
                '}';
    }
}
