package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsClassifyDao;
import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AppletNewsClassifyDaoImpl extends BaseDaoImpl<AppletNewsClassify> implements AppletNewsClassifyDao {
    @Override
    public Integer getMaxSeq() {
        return getSessionTemplate().selectOne(getStatement("getMaxSeq"));
    }

    @Override
    public List<AppletNewsClassifyDTO> getAllNewsClassify(Boolean showState) {
        Map<String,Object> map=new HashMap<>();
        map.put("showState", showState);
        return getSessionTemplate().selectList(getStatement("getAllNewsClassify"), map);
    }
}
