package com.pcloud.book.cultivate.enums;

public enum CultivateChangeTypeEnum {

    //1银两获取2点亮3熄灭4升级5使用能量值6使用技能7银两兑换书币，（鱼丸=银两，星星=书币）
    /**
     * 银两获取
     */
    GET_FISH_BALL(1, "银两获取"),

    /**
     * 点亮
     */
    LIGHTEN(2, "点亮"),
    /**
     * 熄灭
     */
    QUENCH(3, "熄灭"),
    /**
     * 升级
     */
    UPGRADE(4, "升级"),
    /**
     * 使用能量值
     */
    USE_ENERGY(5, "使用能量值"),
    /**
     * 使用技能
     */
    USE_SKILL(6,"使用技能"),
    /**
     * 银两兑换书币
     */
    FISH_BALL_CONVERT_STAR(7,"银两兑换书币"),

    /**
     * 赠送能量给好友
     */
    GIVE_ENERGY_TO_FRIEND(8,"赠送能量给好友"),

    /**
     * 被好友赠送能量
     */
    GET_ENERGY_BY_FRIEND(9,"被好友赠送能量"),

    /**
     * 占好友座位
     */
    HOLD_FRIEND_SEAT(10,"占好友座位"),
    /**
     * 被好友占座(我)
     */
    HOLD_SEAT_BY_FRIEND(11,"被好友占座"),
    /**
     * 退出好友座位
     */
    EXIT_FRIEND_SEAT(12,"退出好友座位"),
    /**
     * 好友退出我的座位(我)
     */
    FRIEND_EXIT_SEAT(13,"好友退出我的座位"),
    /**
     * 将好友踢出座位(我)
     */
    KICK_OUT_FRIEND_BY_SELF(14,"将好友踢出座位"),
    /**
     * 被好友踢出座位
     */
    KICK_OUT_BY_FRIEND(15,"被好友踢出座位"),
    /**
     * 占座好友灯熄灭
     */
    FRIEND_LIGHTS_OUT(16,"占座好友灯熄灭");


    public final Integer code;

    public final String name;

    CultivateChangeTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(Integer code) {
        if (code==null) {
            return null;
        }
        CultivateChangeTypeEnum[] all = values();
        int length = all.length;
        for (int i = 0; i < length; ++i) {
            CultivateChangeTypeEnum cultivateChangeTypeEnum = all[i];
            if (cultivateChangeTypeEnum.code.equals(code)) {
                return cultivateChangeTypeEnum.name;
            }
        }
        return null;
    }

}
