package com.pcloud.book.giftcoupon.dto;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

import lombok.Data;

@Data
public class GiftPackageDTO {

    /**
     * 封面图
     */
    private Long id;
    /**
     * 封面图
     */
    private String coverPic;
    /**
     * 名称
     */
    private String title;
    /**
     * 有效期开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateBegin;
    /**
     * 有效期结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateEnd;
    /**
     * 面额
     */
    private Integer denomination;

    private Integer stock;
    /**
     * 每人领取上限
     */
    private Integer receiveLimit;

    /**
     * (1-未开始，2-进行中，3-已结束,4-未结束)
     */
    private Integer state;
    /**
     * 领取数量
     */
    private Integer receiveNum;
}
