package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.BookGroupAppBiz;
import com.pcloud.book.group.facade.BookGroupAppFacade;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/14 14:35
 **/
@RestController("bookGroupAppFacade")
@RequestMapping("bookGroupApp")
public class BookGroupAppFacadeImpl implements BookGroupAppFacade {

    @Autowired
    private BookGroupAppBiz bookGroupAppBiz;


    @ApiOperation("根据社群码id查询所挂资源统计")
    @GetMapping("getBookGroupAppDTOSByBookGroupId")
    @Override
    public ResponseDto<?> getBookGroupAppDTOSByBookGroupId(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") Long bookGroupId,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)) {
            throw new PermissionException(PermissionException.PERMISSION_NOT_FOUND);
        }
        return new ResponseDto<>(bookGroupAppBiz.getBookGroupAppDTOSByBookGroupId(bookGroupId,currentPage,numPerPage));
    }

    @ApiOperation("根据社群码id导出所挂资源统计")
    @GetMapping("exportBookGroupAppDTOSByBookGroupId")
    @Override
    public ResponseDto<?> exportBookGroupAppDTOSByBookGroupId(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") Long bookGroupId
    ) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)) {
            throw new PermissionException(PermissionException.PERMISSION_NOT_FOUND);
        }
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGroupAppBiz.exportBookGroupAppDTOSByBookGroupId(bookGroupId, systemCode, partyId);
        return new ResponseDto<>();
    }
}
