package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.SelfPushUserDao;
import com.pcloud.book.push.dto.UserCountAndPushDTO;
import com.pcloud.book.push.entity.SelfPushUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：
 * @作者：zhuyajie
 * @创建时间：19:01 2019/11/26
 * @版本：1.0
 */
@Component("selfPushUserDao")
public class SelfPushUserDaoImpl extends BaseDaoImpl<SelfPushUser>implements SelfPushUserDao {

    @Override
    public Integer getCountByPushId(Long pushId) {
        return getSessionTemplate().selectOne(getStatement("getCountByPushId"), pushId);
    }

    @Override
    public List<String> getUserIdListByPushId(Long pushId) {
        return getSessionTemplate().selectList(getStatement("getUserIdListByPushId"), pushId);
    }

    @Override
    public void deleteByPushId(Long pushId) {
        getSessionTemplate().delete(getStatement("deleteByPushId"), pushId);
    }

    @Override
    public List<UserCountAndPushDTO> getCountByPushIds(List<Long> pushIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushIds", pushIds);
        return getSessionTemplate().selectList(getStatement("getCountByPushIds"), map);
    }
}
