package com.pcloud.book.rightsSetting.dao.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("权益设置参数校验")
@Slf4j
public class RightsSettingCheck {

    public void rightsSettingCheck(RightsSetting rightsSetting) {
        log.info("新增权益设置参数校验");
        if (null == rightsSetting){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (StringUtil.isEmpty(rightsSetting.getIntroduce())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益简介为空！");
        }
        if (StringUtil.isEmpty(rightsSetting.getDetail())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益详情为空！");
        }
        if (null == rightsSetting.getCount()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益个数为空！");
        }
        if (null==rightsSetting.getRightsSettingType()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益类型为空！");
        }
        if (rightsSetting.getRightsSettingType()==2 && null==rightsSetting.getBookId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"bookId为空！");
        }
        if (rightsSetting.getRightsSettingType()==1 && null == rightsSetting.getFirstClassify()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"分类为空！");
        }
        checkRightNowItem(rightsSetting);
    }

    private void checkRightNowItem(RightsSetting rightsSetting) {
        if (rightsSetting == null) {
            return;
        }
        if (null != rightsSetting.getOnlineRightsSettingTitle()) {
            checkRightNowItemApp(rightsSetting.getOnlineRightsSettingTitle().getRightsSettingItemList());
        }
        if (null != rightsSetting.getLearningToolTitle()) {
            checkRightNowItemApp(rightsSetting.getLearningToolTitle().getRightsSettingItemList());
        }
        if (null != rightsSetting.getDrawSettingTitle()) {
            checkRightNowItemApp(rightsSetting.getDrawSettingTitle().getRightsSettingItemList());
        }
        if (null != rightsSetting.getGiftCouponPackageTitle() && !ListUtils.isEmpty(rightsSetting.getGiftCouponPackageTitle().getRightsSettingItemList())) {
            for (RightsNowItem item : rightsSetting.getGiftCouponPackageTitle().getRightsSettingItemList()) {
                if (item.getGiftCouponPackageId() == null) {
                    throw new BookBizException(BookBizException.PARAM_IS_NULL, "专享礼包券id为空！");
                }
            }
        }
    }

    private void checkRightNowItemApp(List<RightsNowItem> onlineCourseNowItems) {
        if (ListUtils.isEmpty(onlineCourseNowItems)){
            return;
        }
        for (RightsNowItem item : onlineCourseNowItems) {
            if (item.getServeId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "作品或应用id为空！");
            }
            if (StringUtil.isEmpty(item.getServeType())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "作品或应用类型为空！");
            }
            if (StringUtil.isEmpty(item.getLinkUrl())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "作品或应用链接为空！");
            }
        }
    }
}
