package com.pcloud.book.group.service;

import com.pcloud.book.group.dto.AltAndCountDTO;
import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.book.group.dto.BookGroupClassifyDTO;
import com.pcloud.book.group.dto.BookGroupCountDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupKeywordResourceDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.dto.ErpBookGroupDTO;
import com.pcloud.book.group.dto.ErpGroupQrcodeDTO;
import com.pcloud.book.group.dto.GroupCipherDTO;
import com.pcloud.book.group.dto.GroupUseDTO;
import com.pcloud.book.group.dto.MapBookGroupServeCountDTO;
import com.pcloud.book.group.dto.PersonalQrcodeDTO;
import com.pcloud.book.group.dto.QueryByBookAdviserDTO;
import com.pcloud.book.group.dto.ResourceBrowseParamDto;
import com.pcloud.book.group.dto.SelfRobotBookGroupDTO;
import com.pcloud.book.group.dto.SelfRobotUserDTO;
import com.pcloud.book.group.dto.SelfRobtParamDTO;
import com.pcloud.book.group.dto.UserBookBaseInfoDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.dto.StoreFlowInfoDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * Description 社群书内部接口
 * Created by PENG on 2019/5/14.
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookGroupServiceCloud", path = "book/v1.0/bookGroupService")
@Api(description = "社群书内部接口")
public interface BookGroupService {

    @ApiOperation("获取社群书基本信息")
    @RequestMapping(value = "getBookGroupInfo",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookGroupDTO>> getBookGroupInfo(@RequestParam("bookGroupId")Long bookGroupId) throws BizException;

    @ApiOperation("批量获取社群书基本信息")
    @RequestMapping(value = "getBookGroupInfoByIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BookGroupDTO>>> getBookGroupInfoByIds(@RequestBody List<Long> bookGroupIds) throws BizException;

    @ApiOperation("根据bookId和AdviserId批量获取社群书基本信息")
    @PostMapping(value = "getBookGroupInfoByBookIdAndAdviserId")
    ResponseEntity<ResponseDto<List<BookGroupDTO>>> getBookGroupInfoByBookIdAndAdviserId(@RequestBody QueryByBookAdviserDTO queryByBookAdviserDTO) throws BizException;

    @ApiOperation("为信息流批量获取社群书基本信息")
    @RequestMapping(value = "getFlowInfoByBookGroupIds", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, StoreFlowInfoDto>>> getFlowInfoByBookGroupIds(@RequestBody List<Long> bookGroupIds) throws BizException;

    @ApiOperation("获取指定条数社群书基本信息")
    @RequestMapping(value = "getBookGroupInfoByChannelId",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Map<Long, StoreFlowInfoDto>>> getBookGroupInfoByChannelId(@RequestParam("channelId")Long channelId, @RequestParam("itemNum")Integer itemNum) throws BizException;

    @ApiOperation(value = "知识商城获取社群书信息")
    @RequestMapping(value = "listBookGroup4KnowledgeMall",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<PageBeanNew<StoreFlowInfoDto>>> listBookGroup4KnowledgeMall(@RequestParam(value="channelId",required = false)Long channelId,
                                                                                       @RequestParam("currentPage")int currentPage,
                                                                                       @RequestParam("numPerPage") int numPerPage) throws BizException;

    @ApiOperation("获取社群书基本信息")
    @RequestMapping(value = "getBaseInfoBySceneId",method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookGroupDTO>> getBaseInfoBySceneId(@RequestParam("sceneId")Long sceneId) throws BizException;


    @ApiOperation("更新个人二维码")
    @RequestMapping(value = "updatePersonQrcode",method = RequestMethod.POST)
    void updatePersonQrcode(@RequestBody PersonalQrcodeDTO personalQrcodeDTO) throws BizException;

    @ApiOperation("获取暗号状态")
    @GetMapping("/getCipherState")
    ResponseEntity<ResponseDto<Integer>> getCipherState(@RequestParam("cipher")String cipher) throws BizException;

    @ApiOperation("更新暗号状态为已使用")
    @GetMapping("/updateCipherStateToUsed")
    void updateCipherStateToUsed(@RequestParam("cipher")String cipher, @RequestParam("wxId")String wxId) throws BizException;

    @ApiOperation("获取个人二维码方式群已使用和未使用数量")
    @PostMapping("/getGroupUse")
    ResponseEntity<ResponseDto<GroupUseDTO>> getGroupUse(@RequestBody List<String> altIds) throws BizException;

    @ApiOperation("获取暗号基本信息")
    @GetMapping("/getJoinGroupCipher")
    ResponseEntity<ResponseDto<GroupCipherDTO>> getJoinGroupCipher(@RequestParam("cipher")String cipher) throws BizException;

    @ApiOperation("获取资源浏览数据")
    @PostMapping("getResourcesBrowseCount")
    ResponseEntity<ResponseDto<Map<Long, Long>>> getResourcesBrowseCount(@RequestBody ResourceBrowseParamDto resourceBrowseParamDto);

    @ApiOperation("社群书日加好友人数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "bookGroupId", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始日期", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束日期", dataType = "string", paramType = "query")
    })
    @GetMapping("getBookGroupFriendsCountByDay")
    ResponseEntity<ResponseDto<Map<String, Integer>>> getBookGroupFriendsCountByDay(
            @RequestParam("bookGroupId") Long bookGroupId, @RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);

    @ApiOperation("将1v1旧数据的关键词全部都干掉，有应用或作品的挂在社群书配置资源里面")
    @GetMapping("dealSelfBookGroupKeywordToServer")
    void dealSelfBookGroupKeywordToServer();

    @ApiOperation("补充1v1旧数据的暗号")
    @GetMapping("fillSelfBookGroupCipher")
    void fillSelfBookGroupCipher();

    @ApiOperation("将之前的配置资源取的社群码运营更新为应用本身的运营")
    @GetMapping("dealBookGroupServerChannel")
    void dealBookGroupServerChannel();

    @ApiOperation("获取社群书关键词关联的资源（关键词及1v1配置资源）")
    @GetMapping("getKeyWordResourceByBookGroup")
    ResponseEntity<ResponseDto<List<BookGroupKeywordResourceDTO>>> getKeyWordResourceByBookGroup(
            @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "查社群码下二维码id", httpMethod = "GET")
    @GetMapping("getQrcodeIdsByBookGroupId")
    ResponseEntity<ResponseDto<List<Long>>> getQrcodeIdsByBookGroupId(@RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation("上架所有的个人号配置资源")
    @GetMapping("dealBookGroupServeOldOnShelves")
    void dealBookGroupServeOldOnShelves();

    @ApiOperation(value = "1v1社群码下用户id", httpMethod = "GET")
    @GetMapping("getFriendIdsByBookGroupId")
    ResponseEntity<ResponseDto<List<String>>> getFriendIdsByBookGroupId(@RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "个人号读者统计", httpMethod = "POST")
    @PostMapping("listPageFriendInfo")
    ResponseEntity<ResponseDto<PageBeanNew<SelfRobotUserDTO>>> listPageFriendInfo(@RequestBody @ApiParam SelfRobtParamDTO selfRobtParamDTO);

    @ApiOperation("补充社群书的出版社id")
    @GetMapping("fillAgentIdForBookGroup")
    void fillAgentIdForBookGroup();

    @ApiOperation("获取个人号累计加好友人数")
    @GetMapping("getAddFriendCount")
    ResponseEntity<ResponseDto<Integer>> getAddFriendCount();

    @ApiOperation("获取所有已建分类的1v1的社群码")
    @GetMapping("get1v1HasClassifyBookGroupIds")
    ResponseEntity<ResponseDto<List<Long>>> get1v1HasClassifyBookGroupIds();

    @ApiOperation("根据小号批量获取服务社群书数量")
    @PostMapping("getBookGroupCountMapByAltIds")
    ResponseEntity<ResponseDto<Map<String,Integer>>> getBookGroupCountMapByAltIds(@RequestBody List<String> altIds);

    @ApiOperation("获取小号社群书数量")
    @PostMapping("getSerBookGroupCountByAltIds")
    ResponseEntity<ResponseDto<Integer>> getSerBookGroupCountByAltIds(@RequestBody List<String> altIds);

    @ApiOperation("出版社关联的个人号以及个人号的社群书数量")
    @GetMapping("getAltAndCountDTOListByAgentId")
    ResponseEntity<ResponseDto<List<AltAndCountDTO>>> getAltAndCountDTOListByAgentId(@RequestParam("agentId") Long agentId);

    @ApiOperation("补充社群书旧的作品应用到新的表")
    @GetMapping("addOldBookGroupAppToNew")
    void addOldBookGroupAppToNew();

    @ApiOperation("根据类型获取社群书id集合")
    @GetMapping("getBookGroupIdsByJoinGroupType")
    ResponseEntity<ResponseDto<List<Long>>> getBookGroupIdsByJoinGroupType(@RequestParam("joinGroupType") Integer joinGroupType);

    @ApiOperation("查小号的好友id列表")
    @PostMapping("getFriendIdListByBookAndRobot")
    ResponseEntity<ResponseDto<List<String>>> getFriendIdListByBookAndRobot(@RequestParam("altId") String altId, @RequestBody @ApiParam List<Long> bookIds);

    @ApiOperation("用户扫码书刊名称")
    @PostMapping("mapUserScanBook")
    ResponseEntity<ResponseDto<Map<String, List<UserBookBaseInfoDTO>>>> mapUserScanBook(@RequestParam("altId") String altId, @RequestBody @ApiParam List<String> wxUserIdList);

    @ApiOperation("获取关联社群书数量和名字")
    @GetMapping("getAssocBookGroupByServeInfo")
    ResponseEntity<ResponseDto<List<BookGroupDTO>>> getAssocBookGroupByServeInfo(
            @RequestParam("adviserId") Long adviserId,
            @RequestParam("serveId") Long serveId,
            @RequestParam("serveType") String serveType);

    /**
     * 获取作品或应用关联的社群书数量
     * @param bookGroupCountDTOS
     * @return
     */
    @ApiOperation("获取作品或应用关联的社群书数量")
    @PostMapping("getAssocBookGroupCount")
    ResponseEntity<ResponseDto<List<BookGroupCountDTO>>> getAssocBookGroupCount(@RequestBody List<BookGroupCountDTO> bookGroupCountDTOS);

    @ApiOperation("用户最近关联的社群书")
    @GetMapping("getLatestCipherBookGroup")
    ResponseEntity<ResponseDto<Long>> getLatestCipherBookGroup(@RequestParam("altId") String altId, @RequestParam("wxUserId") String wxUserId);

    @ApiOperation("ERP创建社群二维码")
    @PostMapping("createGroupQrcode4Erp")
    ResponseEntity<ResponseDto<ErpBookGroupDTO>> createGroupQrcode4Erp(@RequestBody ErpGroupQrcodeDTO erpGroupQrcodeDTO);
	
    @ApiOperation("根据用户和社群书id获取个人号信息")
    @GetMapping("getSelfRobotBookGroupInfoByUser")
    ResponseEntity<ResponseDto<SelfRobotBookGroupDTO>> getSelfRobotBookGroupInfoByUser(@RequestParam("wxUserId") String wxUserId, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation("每天增加小程序权益读者数量")
    @GetMapping("addUserCount4RightsSetting")
    void addUserCount4RightsSetting();

    @ApiOperation("通过sceneId查询小程序相关信息")
    @GetMapping("getBookAppletBySceneId")
    ResponseEntity<ResponseDto<BookAppletSceneDTO>> getBookAppletBySceneId(@RequestParam("sceneId") Long sceneId);

    @ApiOperation("根据raysBookId获取特殊二维码的bookGroupId")
    @RequestMapping(value = "/getBookGroupId4OldData", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Long>> getBookGroupId4OldData(
        @RequestParam(value = "raysBookId") Long raysBookId
    ) throws BizException;

    @ApiOperation(value = "批量获取书的资源数",httpMethod = "POST")
    @RequestMapping(value = "/mapBookGroupServeCount", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<String, BookGroupServeCountDTO>>> mapBookGroupServeCount(@RequestBody MapBookGroupServeCountDTO mapBookGroupServeCountDTO);
}
