package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel("小程序资讯评论")
public class AppletNewsCommentDTO extends BaseDto {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("资讯id")
    private Long newsId;

    @ApiModelProperty("评论")
    private String comment;

    @ApiModelProperty("用户")
    private Long wechatUserId;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String headPic;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    protected Date createTime;
}
