package com.pcloud.book.es.biz;

import com.pcloud.book.es.dto.ESBookGroupQrcodeDTO;
import com.pcloud.book.es.dto.GroupQrcodeSearchDTO;
import com.pcloud.book.es.entity.ESBookGroupQrcode;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface ESBookGroupQrcodeBiz {

    /**
     * 初始化数据-将数据从 MySQL 导入到 Elasticsearch 中
     */
    void initData();


    /**
     * 通过微信群ID(xxx@chatroom)获取ES中的群信息
     *
     * @param wxGroupIds 微信群ID
     * @return 取ES中的群信息
     */
    List<ESBookGroupQrcodeDTO> searchByWxGroupIds(List<String> wxGroupIds);

    /**
     * 更新ES中的群信息
     */
    void save(List<ESBookGroupQrcodeDTO> dtos);

    PageBeanNew<GroupQrcodeSearchDTO> search(String text, Integer pageSize, Integer pageNum);
}
