package com.pcloud.book.keywords.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lily
 * @date 2019/4/25 10:17
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class KeywordDTO implements Serializable {

    private static final long serialVersionUID = -6868312018634217941L;
    @ApiModelProperty("关键词标识")
    private Long keywordId;

    @ApiModelProperty("关键词")
    private String keywords;

    @ApiModelProperty("是否仓库词（1：是  0：否）")
    private Integer isWarehouse;

    @ApiModelProperty("仓库关键词id")
    private Long warehouseId;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("关键词应用/作品id")
    private Long serveId;

    @ApiModelProperty("应用/作品")
    private String serveType;

    @ApiModelProperty("关键词连接")
    private String linkUrl;

    @ApiModelProperty("关键词内容")
    private String content;

    @ApiModelProperty("关键词描述")
    private String description;

    @ApiModelProperty("回复类型")
    private Integer replyType;

    @ApiModelProperty("社群书id")
    private Long bookGroupId;

    @ApiModelProperty("创建人")
    private Long createUser;


}
