package com.pcloud.book.record.dao;

import com.pcloud.book.record.entity.AreaStatistics;
import com.pcloud.book.record.entity.BookBrowseRecord;
import com.pcloud.book.record.entity.BookMapStatistics;
import com.pcloud.book.record.entity.ClassifyStatistics;
import com.pcloud.common.core.dao.BaseDao;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;


public interface BookBrowseRecordDAO extends BaseDao<BookBrowseRecord> {
    int deleteByPrimaryKey(Long id);

    int insertSelective(BookBrowseRecord record);

    BookBrowseRecord selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(BookBrowseRecord record);

    int updateByPrimaryKey(BookBrowseRecord record);

    List<BookMapStatistics> getBookCount4Country(String regionCode);

    AreaStatistics getAreaStatistics(String regionCode, Integer areaCode);

    List<ClassifyStatistics> getClassifyStatistics(String regionCode, Integer areaCode);

    void getBookDetail(Map<String, Object> paramMap);
}
