package com.pcloud.common.core.biz;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.FrontEventDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author Shichunshan
 * @date: Created in 2018/4/17 11:09
 * @description:
 */
@Component("frontEventBiz")
public class FrontEventBizImpl implements FrontEventBiz {
	/**
	 *
	 */
	private final static Logger LOGGER = LoggerFactory.getLogger(ConvertQueueBizImpl.class);

	// @Autowired(required=false)
	// @Qualifier("jmsFrontEventTemplate")
	// private JmsTemplate jmsFrontEventTemplate;

	@Resource
	private AmqpTemplate amqpTemplate;

	/**
	 * 发送事件消息
	 *
	 * @param frontEventDto
	 */
	// @Override
	// public void sendFrontEventQueue(FrontEventDto frontEventDto) throws
	// BizException {
	// MessageCreator messageCreator = session ->
	// session.createObjectMessage(frontEventDto);
	// try {
	// jmsFrontEventTemplate.send(messageCreator);
	// } catch (Exception e) {
	// logger.error("发送失败，" + e.getMessage() + "," + frontEventDto, e);
	// throw BizException.SEND_QUEUE_FAIL;
	// }
	// logger.info("发送成功，" + frontEventDto);
	// }

	/**
	 * 文件转码QUEUE
	 */
	@Override
	@ParamLog(description = "大数据埋点QUEUE")
	public void sendFrontEventQueue(FrontEventDto frontEventDto) throws BizException {
		LOGGER.info("===大数据埋点===start --> frontEventDto:{}", frontEventDto);
		amqpTemplate.convertAndSend(MQQueueConstant.FRONT_EVENT, frontEventDto);
		LOGGER.info("===大数据埋点===end --> frontEventDto:{}", frontEventDto);
	}

	/**
	 * 生成(事件ID/漏斗ID)前缀
	 *
	 * @param targetClass
	 * @param targetType
	 */
	public static String generatePrefix(String targetClass, String targetType) {
		return targetClass.toLowerCase() + "_" + targetType.toLowerCase() + "_";
	}
}
