package com.pcloud.common.core.biz;

import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.SendAppMessageDto;
import com.pcloud.common.core.dto.SendEmailDto;
import com.pcloud.common.core.dto.SendMessageDto;
import com.pcloud.common.core.dto.SendNotifyDto;
import com.pcloud.common.utils.mq.MqMessage;
import com.pcloud.common.utils.mq.MqMessageTypeEnum;

import javax.annotation.Resource;

/**
 * @描述：邮件业务实现
 * @作者：shichunshan
 * @创建时间：2016年6月24日,下午2:19:27 @版本：1.0
 */
@Component("messageQueueBiz")
public class MessageBizImpl implements MessageBiz {

	private final static Logger logger = LoggerFactory.getLogger(MessageBizImpl.class);

	@Resource
	private AmqpTemplate amqpTemplate;

	/**
	 * 发送邮件
	 * 
	 * @param sendEmailDto
	 */
	@Override
	@ParamLog("发送邮件")
	public void sendEmail(SendEmailDto sendEmailDto) {
		try {
			ObjectMapper objectMapper = new ObjectMapper();
			String content = objectMapper.writeValueAsString(sendEmailDto);
			MqMessage mqMessage = new MqMessage(MqMessageTypeEnum.EMAIL, content);
			amqpTemplate.convertAndSend(MQQueueConstant.MESSAGE, mqMessage);
		} catch (Exception e) {
			logger.error("邮件发送失败，" + e.getMessage() + "," + sendEmailDto, e);
		}
	}

	/**
	 * 发送站内信
	 */
	@Override
	@ParamLog("发送站内信")
	public void sendLetter(SendNotifyDto sendNotifyDto) {
		try {
			ObjectMapper objectMapper = new ObjectMapper();
			String content = objectMapper.writeValueAsString(sendNotifyDto);
			MqMessage mqMessage = new MqMessage(MqMessageTypeEnum.LETTER, content);
			amqpTemplate.convertAndSend(MQQueueConstant.MESSAGE, mqMessage);
		} catch (Exception e) {
			logger.error("站内信发送失败，" + e.getMessage() + "," + sendNotifyDto, e);
		}
	}

	/**
	 * 发送短信
	 */
	@Override
	@ParamLog("发送短信")
	public void sendSMS(SendMessageDto sendMessageDto) {
		try {
			ObjectMapper objectMapper = new ObjectMapper();
			String content = objectMapper.writeValueAsString(sendMessageDto);
			MqMessage mqMessage = new MqMessage(MqMessageTypeEnum.SHORT_MESSAGE, content);
			amqpTemplate.convertAndSend(MQQueueConstant.MESSAGE, mqMessage);
		} catch (Exception e) {
			logger.error("短信发送失败，" + e.getMessage() + "," + sendMessageDto, e);
		}
	}

	/**
	 * 发送app推送
	 */
	@Override
	@ParamLog("发送APP推送")
	public void sendAppMessage(SendAppMessageDto sendAppMessageDto) {
		try {
			ObjectMapper objectMapper = new ObjectMapper();
			String content = objectMapper.writeValueAsString(sendAppMessageDto);
			MqMessage mqMessage = new MqMessage(MqMessageTypeEnum.APP_MESSAGE, content);
			amqpTemplate.convertAndSend(MQQueueConstant.MESSAGE, mqMessage);
		} catch (Exception e) {
			logger.error("APP推送发送失败，" + e.getMessage() + "," + sendAppMessageDto, e);
		}
	}

}
