package com.pcloud.common.core.biz.impl;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.AdviserTaskQueueBiz;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.AdviserTaskDTO;
import com.pcloud.common.exceptions.BizException;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName com.pcloud.common.core.biz.impl.AdviserTaskQueueBizImpl
 * @Author zhuyajie
 * @Description 编辑升级任务
 * @Date 2021/4/16 16:16
 * @Version 1.0
 **/
@Component
@Slf4j
public class AdviserTaskQueueBizImpl implements AdviserTaskQueueBiz {


    @Autowired
    private AmqpTemplate amqpTemplate;

    @Override
    @ParamLog("发送编辑任务队列")
    public void sendAdviserTaskQueue(AdviserTaskDTO adviserTaskDTO) {
        if (adviserTaskDTO == null) {
            throw BizException.PARAM_IS_NULL;
        }
        try {
            amqpTemplate.convertAndSend(MQQueueConstant.ADVISER_TASK, adviserTaskDTO);
        } catch (Exception e) {
            log.error("发送编辑任务队列失败，" + e.getMessage() + "," + adviserTaskDTO.toString(), e);
            throw BizException.SEND_QUEUE_FAIL;
        }
    }
}
