package com.pcloud.common.core.constant;

/**
 * @ClassName com.pcloud.common.core.constant.AdviserTaskConstants
 * @Author zhuyajie
 * @Description 编辑任务常量
 * @Date 2021/4/16 16:28
 * @Version 1.0
 **/
public class AdviserTaskConstants {


    /**
     * 编辑升级任务操作类型
     * @author：zhuyajie
     * @date：2021/4/19 10:48
     *  * @param null
     */
    public enum OperateTypeEnum {
        //1创建书刊
        CREATE_BOOK("CREATE_BOOK"),
        //1创建二维码
        CREATE_QRCODE("CREATE_QRCODE"),
        //2配置资源上书
        CONFIGURE_RESOURCE("CONFIGURE_RESOURCE"),
        //3下载二维码，印码上书
        DOWNLOAD_QRCODE("DOWNLOAD_QRCODE"),
        //4图书发行
        PUBLISH_BOOK("PUBLISH_BOOK"),
        //5查看书刊统计（流量和收益数据）
        VIEW_BOOK_STATISTICS("VIEW_BOOK_STATISTICS"),
        //6体验新上线应用
        CREATE_NEW_APP("CREATE_NEW_APP"),
        //7给产品经理提意见
        ADVICE_TO_PCLOUD("ADVICE_TO_PCLOUD"),
        //8立项一本书
        MAKE_PROJECT_APPROVAL("MAKE_PROJECT_APPROVAL");

        private String value;
        OperateTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    /**
     * 编辑任务目标类型
     * @author：zhuyajie
     * @date：2021/4/19 12:01
     *  * @param null
     */
    public enum TargetTypeEnum {
        BOOK("BOOK"),
        QRCODE("QRCODE"),
        APP("APP"),
        FEEDBACK("FEEDBACK");
        private String value;
        TargetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }
}
