/**
 *
 */
package com.pcloud.common.core.constant;

/**
 * RabbitMQ Topic路由名称常量类
 *
 * @author：songx
 * @date：2018年8月17日,上午10:48:18
 */
public class MQTopicProducer {
	/**
	 * 个人号发送文字消息
	 */
	public static final String SELF_ROBOT_SEND_TEXT = "topic.SelfRobotSendText";
	/**
	 * 监听小号上下线
	 */
	public static final String ROBOT_REAL_STATUS = "topic.robotRealStatus";

	/**
	 * 文件转码结束(PDF、EXCEL)
	 */
	public static final String FILE_TRANSCODE = "topic.fileTranscode";

	/**
	 * 音频配音结束(MP3)
	 */
	public static final String FILE_DUBBING = "topic.fileDubbing";

	/**
	 * 报名新增用户
	 */
	public static final String BM_ADD_USER = "topic.bmAddUser";

	/**
	 * 应用新增
	 */
	public static final String APP_ADD = "topic.appAdd";

	/**
	 * 应用修改
	 */
	public static final String APP_UPDATE = "topic.appUpdate";

	/**
	 * 应用删除
	 */
	public static final String APP_DELETE = "topic.appDelete";

	/**
	 * 应用删除(新)
	 */
	public static final String APP_DELETE_NEW = "topic.appDeleteNew";

	/**
	 * 应用审核
	 */
	public static final String APP_AUDIT = "topic.appAudit";

	/**
	 * 选择默认渠道
	 */
	public static final String CHOOSE_DEFAULT_CHANNEL = "topic.chooseDefaultChannel";

	/**
	 * 删除视频
	 */
	public static final String DELETE_VIDEO = "topic.deleteVideo";

	/**
	 * 标签修改
	 */
	public static final String LABEL_UPDATE = "topic.labelUpdate";

	/**
	 * 支付
	 */
	public static final String PAYMENT = "topic.payment";

	/**
	 * TIP
	 */
	public static final String TIP = "topic.tip";
	/**
	 * 给读者的打赏
	 */
	public static final String TIP_FOR_WECHAT_USER = "topic.tipForWechatUser";

	/**
	 * GENUINE
	 */
	public static final String GENUINE = "topic.genuine";

	/**
	 * 订单完成
	 */
	public static final String FINISH_ORDER = "topic.finishOrder";

	/**
	 * 资源修改
	 */
	public static final String RESOURCE_UPDATE = "topic.resourceUpdate";

	/**
	 * 资源删除
	 */
	public static final String RESOURCE_DELETE = "topic.resourceDelete";

	/**
	 * 扫码记录
	 */
	public static final String SCAN_RECORD = "topic.scanRecord";

	/**
	 * 图书删除
	 */
	public static final String BOOK_DELETE = "topic.bookDelete";

	/**
	 * BOOKTHAW
	 */
	public static final String BOOK_THAW = "topic.bookThaw";

	/**
	 * TEMPLETAPPCREATE
	 */
	public static final String TEMPLET_APP_CREATE = "topic.templetAppCreate";

	/**
	 * PERMISSION
	 */
	public static final String PERMISSION = "topic.permission";

	/**
	 * PROMOTION_EXPIRE
	 */
	public static final String PROMOTION_EXPIRE = "topic.promotionExpire";

	/**
	 * 商品修改
	 */
	public static final String PRODUCT_UPDATE = "topic.productUpdate";

	/**
	 * 商品删除
	 */
	public static final String PRODUCT_DELETE = "topic.productDelete";

	/**
	 * 商品审核
	 */
	public static final String PRODUCT_AUDIT = "topic.productAudit";

	/**
	 * 商品图片1修改
	 */
	public static final String PRODUCT_PIC1_UPDATE = "topic.productPic1Update";

	/**
	 * 用户注册
	 */
	public static final String REGISTER_PARTY = "topic.registerParty";

	/**
	 * 用户修改
	 */
	public static final String UPDATE_PARTY = "topic.updateParty";

	/**
	 * 问答确认
	 */
	public static final String QA_ASK = "topic.qaAsk";

	/**
	 * 问答完成
	 */
	public static final String QA_FINISH = "topic.qaFinish";

	/**
	 * 问答答案
	 */
	public static final String QA_ANSWER = "topic.qaAnswer";

	/**
	 * 问答取消
	 */
	public static final String QA_REFUSE = "topic.qaRefuse";

	/**
	 * QR_MESSAGE_UPDATE
	 */
	public static final String QR_MESSAGE_UPDATE = "topic.qrMessageUpdate";

	/**
	 * GIVE_GIFT
	 */
	public static final String GIVE_GIFT = "topic.giveGift";

	/**
	 * 修改密码
	 */
	public static final String UPDATE_PWD = "topic.updatePwd";

	/**
	 * 管理消息
	 */
	public static final String MANAGE_MESSAGE = "topic.manageMessage";

	/**
	 * RETURN_4_ADVISER
	 */
	public static final String RETURN_4_ADVISER = "topic.return4adviser";

	/**
	 * 退款
	 */
	public static final String REFUND = "topic.refund";

	/**
	 * 退货
	 */
	public static final String REFUND_PRODUCT = "topic.refundProduct";

	/**
	 * 发货
	 */
	public static final String SEND_PRODUCT = "topic.sendProduct";

	/**
	 * 确认收货
	 */
	public static final String CONFIRM_ORDER = "topic.confirmOrder";

	/**
	 * 申请退货
	 */
	public static final String APPLY_REFUND_PRODUCT = "topic.applyRefundProduct";

	/**
	 * 取消订单
	 */
	public static final String CANCEL_ORDER = "topic.cancelOrder";

	/**
	 * 模板二维码扫描
	 */
	public static final String TEMP_QRCODE_SCAN = "topic.tempQrcodeScan";

	/**
	 * 删除二维码
	 */
	public static final String DELETE_QRCODE = "topic.deleteQrcode";

	/**
	 * 二维码图书修改
	 */
	public static final String QRCODE_BOOK_UPDATE = "topic.qrcodeBookUpdate";

	/**
	 * 重置
	 */
	public static final String RECHARGE = "topic.recharge";

	/**
	 * 改变显示状态
	 */
	public static final String CHANGE_SHOW_STATE = "topic.changeShowState";

	/**
	 * 删除合作出版社
	 */
	public static final String DELETE_COOPERATIVE_AGENT = "topic.deleteCooperativeAgent";

	/**
	 * TASK_BONUS
	 */
	public static final String TASK_BONUS = "topic.taskBonus";

	/**
	 * 读者消息
	 */
	public static final String READER_MESSAGE = "topic.readerMessage";

	/**
	 * 记录用户习惯
	 */
	public static final String RECORD_USER_HABIT = "topic.recordUserHabit";

	/**
	 * 扫码
	 */
	public static final String SCAN_QRCODE = "topic.scanQrcode";

	/**
	 * topic交换机名称(勿改)
	 */
	public static final String EXCHAGE = "rays.topic";

	/**
	 * 更新图书封面图
	 */
	public static final String UPDATE_BOOK_COVERIMG = "topic.updateBookCoverImg";

	/**
	 * 更新图书名称
	 */
	public static final String UPDATE_BOOK_NAME = "topic.updateBookName";

	/**
	 * 微信用户关系
	 */
	public static final String WECHAT_RELATE_INFO = "topic.wechatRelateInfo";

	/**
	 * 更新用户头像
	 */
	public static final String UPDATE_USER_HEADURL = "topic.updateUserHeadUrl";

	/**
	 * 入群
	 */
	public static final String ADD_WXGROUP = "topic.addWXGroup";

	/**
	 * 微信群发送文字消息
	 */
	public static final String WXGROUP_SEND_TEXT = "topic.WXGroupSendText";

	/**
	 * 新用户消息
	 */
	public static final String PUSH_ADD_USER_MESSAGE = "topic.pushAddUserMessage";

	/**
	 * 签到打卡作者返现TOPIC
	 */
	public static final String ATTENDANCETASK_CASHBACK_MERCHANT = "topic.attendancetaskCashbackMerchant";

	/**
	 * 修改微信群名称
	 */
	public static final String UPDATE_WXGROUP_NAME = "topic.updateWXGroupName";

	/**
	 * 微信群打卡关键词匹配TOPIC
	 */
	public static final String PUSH_BOOK_CLOCK_KEYWORD = "topic.pushBookClockKeyword";

	/**
	 * 微信群用户绑定TOPIC
	 */
	public static final String WXGROUP_USER_BIND = "topic.wXGroupUserBind";
	/**
	 * 商品创建
	 */
	public static final String PRODUCT_CREATE = "topic.productCreate";

	/**
	 * 代理商删除TOPIC
	 */
	public static final String DELETE_PROMOTER = "topic.deletePromoter";
	/**
	 * 社群书群分类删除
	 */
	public static final String GROUP_CLASSIFY_DELETE = "topic.groupClassifyDelete";

	/**
	 * 微信群学习报告
	 */
	public static final String WXGROUP_LEARNING_REPORT = "topic.wxGroupLearningReport";

	/**
	 * 同意加好友
	 */
	public static final String WX_AGREE_ADD_USER = "topic.wxAgreeAddUser";

	/**
	 * 任务打卡分享到微信群
	 */
	public static final String ATTENDANCE_TASK_SHARE="topic.attendanceTaskShare";

	/**
	 * 直播课开播前十分钟开播提醒TOPIC
	 */
	public static final String WX_LIVE_BROADCAST_REMINDER = "topic.wxLiveBroadcastReminder";

	/**
	 * 修改微信群名称
	 */
	public static final String MODIFY_WXGROUP_NAME = "topic.modifyWXGroupName";

	/**
	 * 扫社群码人数达到一定数量
	 */
	public static final String SOME_USER_SCAN_BOOK_GROUP = "topic.someUserScanBookGroup";

	/**
	 * 扫二维码码人数达到一定数量
	 */
	public static final String SOME_USER_SCAN_QRCODE = "topic.someUserScanQrcode";

	/**
	 * 拼团支付
	 */
	public static final String PAYMENT_MERGE_BUY = "topic.paymentMergeBuy";

	/**
	 * 完成拼团
	 */
	public static final String FINISH_MERGE_BUY = "topic.finishMergeBuy";

	/**
	 * 微信发送非文字消息
	 */
	public static final String WXGROUP_SEND_NOT_TEXT = "topic.WXGroupSendNotText";

	/**
	 * QQ发送文字消息
	 */
	public static final String QQ_SEND_NOT_TEXT = "topic.QQSendNotText";

	/**
	 * erp端自动创建书刊
	 */
	public static final String ERP_AUTO_CREATE_BOOK = "topic.erpCreateBook";

	/**
	 * 工具支付
	 */
	public static final String TOOL_PAY = "topic.toolPay";

	/**
	 * 淘宝天猫商品信息爬取
	 */
	public static final String CRAWLER_RESULT = "topic.productCrawlerResult";

	/**
	 * 作业本小程序支付
	 */
	public static final String EXERCISE_BOOK_PAY = "topic.exerciseBookPay";

	/**
	 * 外刊阅读支付
	 */
	public static final String FOREIGN_READ_PAY = "topic.foreignReadPay";

	/**
	 * 超级搜索
	 */
	public static final String UPDATE_SUPER_SEARCH = "topic.updateSuperSearch";

	/**
	 * 应用复制
	 */
	public static final String DUPLICATE_APP = "topic.duplicateApp";

	/**
	 * 浏览记录更新用户信息
	 */
	public static final String MODIFY_READER = "topic.modifyReader";

	/**
	 * 社群内容（互助、评论、读书笔记、打卡）
	 */
	public static final String APPLET_USER_EVENT = "topic.appletUserEvent";
	/**
	 * 社群内容删除
	 */
	public static final String APPLET_EVENT_DELETE = "topic.appletEventDelete";

	/**
	 *  裂变海报工具关注
	 */
	public static final String FISSION_POSTER_SUBSCRIBE = "topic.fissionPosterSubscribe";

	/**
	 * 会员活动书刊配置
	 */
	public static final String MEMBER_ACTIVITY_BOOK_SET = "topic.memberActivityBookSet";

	/**
	 * 新读者关注
	 */
	public static final String READER_SUBSCRIBE = "topic.subscribe";

	/**
	 *  服务消息预警
	 */
	public static final String ALERT_MESSAGE_COUNT = "topic.alertMessageCount";
	/**
	 * 文本转语音
	 */
	public static final String TEXT_TO_SPEACH = "topic.textToSpeach";

	/**
	 * 应用修改未审核旧数据修改
	 */
	public static final String APP_OLD_DATA_CACHE_UPDATE = "topic.appOldDataCacheUpdate";

	/**
	 * 应用修改未审核旧数据删除
	 */
	public static final String APP_OLD_DATA_CACHE_DELETE = "topic.appOldDataCacheDelete";
}
