package com.pcloud.common.core.constant;
/**
 * 
 * @描述：做任务过程中的各种行为的枚举类
 * @作者：huanghui
 * @创建时间：2017年7月27日
 * @版本：1.0
 */
public enum TaskBehaviorCode {
	/**
	 * 创建
	 */
	CREATE(0),
	/**
	 * 审核，书籍完成申诉
	 */
	AUDIT(1),
	/**
	 * 提交申诉
	 */
	COMMIT_APPEAL(2),
	/**
	 * 其他操作
	 * 
	 * 只有一个步骤的任务，包括：新增书刊、创建二维码、添加应用推广作品、设置应用悬浮商品、配置扫码回复、书刊关联二维码、添加书刊配套资源
	 * 						、确认问答、审核评论、回复评论、创建一键式新增服务、设置作者语音、配置智能推送
	 */
	OTHER(3);
	
	public int code;
	
	TaskBehaviorCode(int code) {
		this.setCode(code);
	}

	public int getCode() {
		return code;
	}


	public void setCode(int code) {
		this.code = code;
	}
}
