package com.pcloud.common.core.datasource;

import com.alibaba.druid.stat.DruidStatManagerFacade;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Druid统计数据重置
 */
class DruidStatsResetManager {

    private static final Logger LOGGER = LoggerFactory.getLogger(DruidStatsResetManager.class);

    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1,
            new BasicThreadFactory.Builder().namingPattern("druid-stats-reset-%d").build());

    /**
     * 定时重置
     */
    static void resetScheduledWithFixedDelay() {
        executor.scheduleWithFixedDelay(() -> {
            DruidStatManagerFacade.getInstance().resetAll();

            LOGGER.info("druid stats data reset all executed completed.");

        }, 5, 5, TimeUnit.MINUTES);
    }
}
