package com.pcloud.common.core.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品信息爬取DTO
 *
 * @author guiq
 * @version 1.0
 * @since 2020/11/17
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class ProductCrawlerDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * itemID
     */
    private Long recordId;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 商品图片
     */
    private String pic;

    /**
     * 预览图1
     */
    private String gallery1;

    /**
     * 预览图2
     */
    private String gallery2;

    /**
     * 预览图3
     */
    private String gallery3;

    /**
     * 预览图4
     */
    private String gallery4;

    /**
     * 预览图5
     */
    private String gallery5;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 促销价
     */
    private BigDecimal promotionalPrice;

    /**
     * 支持的支付方式
     */
    private String payMethod;

    /**
     * 承诺服务
     */
    private String servePromise;

    /**
     * 商品描述详情
     */
    private String description;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 任务状态
     */
    private Integer status;

}
