package com.pcloud.common.core.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 模板消息dto
 *
 * @author 作者 : lili
 * @version 1.0
 * @date 创建时间：2016年11月17日 下午12:03:48
 * @return
 */
public class TemplateMessageDto implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -4132417523244980195L;

    /**
     * 场景编码值
     */
    private String sceneCode;

    /**
     * 接收消息的当事人ID
     */
    private Long receivePartyId;

    /**
     * 成员账号接收人
     */
    private List<Long> receiveMemberPartyIds;

    /**
     * 接收消息角色（CHANNEL/AGENT/MERCHANT/ADVISER）
     */
    private String receivePartyRole;

    /**
     * 公众号所属当事人ID
     */
    private Long sendPartyId;

    /**
     * 公众号所属当事人角色（CHANNEL/AGENT）
     */
    private String sendPartyRole;

    /**
     * 微信用户
     */
    private Long wechatUserId;

    /**
     * openId
     */
    private String openId;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * url
     */
    private String url;

    /**
     * 参数
     */
    private Map<String, String> temParam;

    /**
     * 发送类型（0: 通过wechatUserId  1 ：通过openId 及昵称  2.通过当事人标识）
     */
    private String sendType;

    /**
     * 公众号标识
     */
    private Long accountSettingId;

    /**
     * 是否为应用
     */
    private Boolean isApp;

    /**
     * 应用类型
     */
    private String appType;

    /**
     * 消息来源分类
     */
    private String fromCategory;
    /**
     * 所需跳转到的小程序appid（该小程序appid必须与发模板消息的公众号是绑定关联关系，暂不支持小游戏）
     */
    private String miniprogramAppid;
    /**
     * 所需跳转到小程序的具体页面路径，支持带参数,（示例index?foo=bar），要求该小程序已发布，暂不支持小游戏
     */
    private String miniprogramPagepath;

    public String getMiniprogramAppid() {
        return miniprogramAppid;
    }

    public void setMiniprogramAppid(String miniprogramAppid) {
        this.miniprogramAppid = miniprogramAppid;
    }

    public String getMiniprogramPagepath() {
        return miniprogramPagepath;
    }

    public void setMiniprogramPagepath(String miniprogramPagepath) {
        this.miniprogramPagepath = miniprogramPagepath;
    }

    public String getFromCategory() {
        return fromCategory;
    }

    public void setFromCategory(String fromCategory) {
        this.fromCategory = fromCategory;
    }

    public Long getAccountSettingId() {
        return accountSettingId;
    }

    public void setAccountSettingId(Long accountSettingId) {
        this.accountSettingId = accountSettingId;
    }

    public String getSceneCode() {
        return sceneCode;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getTemParam() {
        return temParam;
    }

    public void setTemParam(Map<String, String> temParam) {
        this.temParam = temParam;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getSendType() {
        return sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public Long getReceivePartyId() {
        return receivePartyId;
    }

    public void setReceivePartyId(Long receivePartyId) {
        this.receivePartyId = receivePartyId;
    }

    public String getReceivePartyRole() {
        return receivePartyRole;
    }

    public void setReceivePartyRole(String receivePartyRole) {
        this.receivePartyRole = receivePartyRole;
    }

    public Long getSendPartyId() {
        return sendPartyId;
    }

    public void setSendPartyId(Long sendPartyId) {
        this.sendPartyId = sendPartyId;
    }

    public String getSendPartyRole() {
        return sendPartyRole;
    }

    public void setSendPartyRole(String sendPartyRole) {
        this.sendPartyRole = sendPartyRole;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Boolean getIsApp() {
        return isApp;
    }

    public void setIsApp(Boolean isApp) {
        this.isApp = isApp;
    }

    public String getAppType() {
        return appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public List<Long> getReceiveMemberPartyIds() {
        return receiveMemberPartyIds;
    }

    public void setReceiveMemberPartyIds(List<Long> receiveMemberPartyIds) {
        this.receiveMemberPartyIds = receiveMemberPartyIds;
    }

    @Override
    public String toString() {
        return "TemplateMessageDto{" +
                "sceneCode='" + sceneCode + '\'' +
                ", receivePartyId=" + receivePartyId +
                ", receiveMemberPartyIds=" + receiveMemberPartyIds +
                ", receivePartyRole='" + receivePartyRole + '\'' +
                ", sendPartyId=" + sendPartyId +
                ", sendPartyRole='" + sendPartyRole + '\'' +
                ", wechatUserId=" + wechatUserId +
                ", openId='" + openId + '\'' +
                ", nickName='" + nickName + '\'' +
                ", url='" + url + '\'' +
                ", temParam=" + temParam +
                ", sendType='" + sendType + '\'' +
                ", accountSettingId=" + accountSettingId +
                ", isApp=" + isApp +
                ", appType='" + appType + '\'' +
                ", fromCategory='" + fromCategory + '\'' +
                ", miniprogramAppid='" + miniprogramAppid + '\'' +
                ", miniprogramPagepath='" + miniprogramPagepath + '\'' +
                '}';
    }

}
