package com.pcloud.common.core.dto;

import com.pcloud.common.core.constant.WeektaskBehaviorCode;
import com.pcloud.common.core.constant.WeektaskCode;

import java.io.Serializable;

/**
 * 周任务完成通知dto
 *
 * @author huanghui
 * @create 2017-09-20 18:04
 **/
public class WeektaskMessageDto implements Serializable {

    private static final long serialVersionUID = 8941539180549234261L;
    /**
     * 周任务枚举
     */
    private WeektaskCode weektaskCode;
    /**
     * 编辑id
     */
    private Long adviserId;

    /**
     * 目标id, 任务过程中的对应id，比如审核应用时就是这个应用id
     */
    private Long targetId;
    /**
     * 任务过程中的行为
     */
    private WeektaskBehaviorCode weektaskBehaviorCode;
    /**
     * 类型
     */
    private String type;
    /**
     * 场景
     */
    private String scene;
    /**
     * 书籍id,成就任务-配置二维码中用的得
     */
    private Long bookId;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public WeektaskCode getWeektaskCode() {
        return weektaskCode;
    }

    public void setWeektaskCode(WeektaskCode weektaskCode) {
        this.weektaskCode = weektaskCode;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public WeektaskBehaviorCode getWeektaskBehaviorCode() {
        return weektaskBehaviorCode;
    }

    public void setWeektaskBehaviorCode(WeektaskBehaviorCode weektaskBehaviorCode) {
        this.weektaskBehaviorCode = weektaskBehaviorCode;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    @Override
    public String toString() {
        return "WeektaskMessageDto{" +
                "weektaskCode=" + weektaskCode +
                ", adviserId=" + adviserId +
                ", targetId=" + targetId +
                ", weektaskBehaviorCode=" + weektaskBehaviorCode +
                ", type='" + type + '\'' +
                ", bookId=" + bookId +
                '}';
    }
}