/**
 * 
 */
package com.pcloud.common.core.facade;

import com.pcloud.common.core.biz.MessageBiz;
import com.pcloud.common.core.dto.SendEmailDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 接口暂时只限ERP使用，有可能后期会加权限验证
 */
@Api("ERP接口")
@RequestMapping(value = "/erpInterface")
@RestController("erpInterfaceFacade")
public class ErpInterfaceFacade {

	@Autowired
	MessageBiz messageBiz;

	@ApiOperation("发送邮件")
	@PostMapping("/sendEmail")
	public ResponseDto<Boolean> sendEmail(SendEmailDto sendEmailDto) throws BizException, PermissionException, JsonParseException {
		messageBiz.sendEmail(sendEmailDto);
		return new ResponseDto<>(true);
	}
}
