/**
 * 
 */
package com.pcloud.common.config;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.context.annotation.config.NacosPropertySource;
import com.alibaba.nacos.spring.util.NacosUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * 环境配置基础类
 * @author diseng
 *
 */
@Configuration
@NacosPropertySource(dataId = "public_user.properties")
public class PublicConfig {

	private static Logger LOGGER = LoggerFactory.getLogger(PublicConfig.class);

	/**
	 * 系统文件配置 加载。
	 */
	@Value("${IS_DEV_STATUS}")
	public void setIsDevStatus(Boolean v) {
		IS_DEV_STATUS = v;
	}

	@Value("${PWD_TIMES_USE_KAPTCHA}")
	public void setPwdTimesUseKaptcha(Integer v) {
		PWD_TIMES_USE_KAPTCHA = v;
	}

	@Value("${IS_USE_KAPTCHA}")
	public void setIsUseKaptcha(Boolean v) {
		IS_USE_KAPTCHA = v;
	}

	@Value("${PWD_ERROR_LIMIT_TIME}")
	public void setPwdErrorLimitTime(Integer v) {
		PWD_ERROR_LIMIT_TIME = v;
	}

	@Value("${PWD_ERROR_LIMIT_TIMES}")
	public void setPwdErrorLimitTimes(Integer v) {
		PWD_ERROR_LIMIT_TIMES = v;
	}

	/**
	 * 密码错误限制次数
	 */
	public static Integer PWD_ERROR_LIMIT_TIMES;

	/**
	 * 密码错误限制时间（分钟）
	 */
	public static Integer PWD_ERROR_LIMIT_TIME;

	/**
	 * 门户是否使用验证码 配合密码错误次数值使用
	 */
	public static boolean IS_USE_KAPTCHA;

	/**
	 * 密码错误次数值 将 出现验证码，如果值为0 则永远不会出现验证码
	 */
	public static Integer PWD_TIMES_USE_KAPTCHA;

	/**
	 * 是否开发状态
	 */
	public static boolean IS_DEV_STATUS;

	/**
	 * 系统文件配置 加载。
	 */
	public static Map<String, String> PUBLIC_SYSTEM = new HashMap<>();

	public static void loadPublicSystem(ConfigService configService) throws NacosException {
		String config = configService.getConfig("public_system.properties", Constants.DEFAULT_GROUP, Constants.RECV_WAIT_TIMEOUT);
		Map<String, Object> p = NacosUtils.toProperties(config);
		p.forEach((k, v) -> {
			PUBLIC_SYSTEM.put(k, v.toString());
		});
		LOGGER.info("public system loaded completed, size={}", PUBLIC_SYSTEM.size());
	}
}
