package com.pcloud.common.enums;

/**
 * 应用类型路由
 *
 * @Author: songx
 * @Date: 2019/7/2,10:15
 */
public enum AppRouteEnum {
    
    /**
     * 一对一辅导
     */
    CC("cc", AppTypeEnum.TUTOR.value),
    
    /**
     * 圈子
     */
    GROUP("group", AppTypeEnum.GROUP.value),
    
    /**
     * 扫扫看
     */
    KK("kk", AppTypeEnum.KK.value),
    
    /**
     * 专题
     */
    ST("st", AppTypeEnum.SPECIAL.value),
    
    /**
     * 背单词
     */
    WD("wd", AppTypeEnum.RECITE_WORD.value),
    
    /**
     * 数据采集/问卷调查
     */
    QN("qn", AppTypeEnum.DA.value),
    
    /**
     * 报名
     */
    REPLY_SCENE("mt", AppTypeEnum.BM.value),
    
    /**
     * 投票
     */
    VT("vt", AppTypeEnum.VOTE.value),
    
    /**
     * 题库
     */
    PRETEST("pretest", AppTypeEnum.ITEM_BANK.value),
    
    /**
     * 标准分
     */
    ZSCORE("zscore", AppTypeEnum.ZSCORE.value),
    
    /**
     * 读书卡片
     */
    BOOKCARD("card", AppTypeEnum.BOOKCARD.value),
    
    /**
     * 教育表格
     */
    TB("tb", AppTypeEnum.EF.value),
    
    /**
     * 直播
     */
    LIVE("live", AppTypeEnum.LIVE_TIMETABLE.value),
    
    /**
     * 打卡
     */
    CLOCK("clock", AppTypeEnum.CLOCK.value),
    
    /**
     * 伴读魔法箱
     */
    AUDIO_MAGIC("magic", AppTypeEnum.AUDIO_MAGIC.value),
    
    /**
     * 课件
     */
    COURSE_WARE("cw", AppTypeEnum.COURSE_WARE.value),
    
    /**
     * 读者反馈
     */
    NAIRE("qn", AppTypeEnum.NAIRE.value),
    
    /**
     * 互动墙
     */
    INTERACT("interact", AppTypeEnum.INTERACT.value),
    
    /**
     * 抽奖
     */
    DRAW("luck", AppTypeEnum.DRAW.value),
    
    /**
     * 教辅资料包
     */
    TEACH_RESOURCE("tr", AppTypeEnum.TEACH_RESOURCE.value),
    
    /**
     * 测试工具
     */
    TEST("tt", AppTypeEnum.TEST.value),
    
    /**
     * 愿望单
     */
    WISH("wish", AppTypeEnum.WISH.value),
    
    /**
     * 笔顺动图
     */
    STROKE_ORDER("pen", AppTypeEnum.STROKE_ORDER.value),
    
    /**
     * 生词听写
     */
    WORD_DICTATION("dictation", AppTypeEnum.WORD_DICTATION.value),
    
    /**
     * 配套听力
     */
    MATCH_LISTEN("mv", AppTypeEnum.MATCH_LISTEN.value),
    
    /**
     * 开通会员
     */
    MEMBER("member", AppTypeEnum.MEMBER.value),
    
    /**
     * 课文诵读
     */
    ARTICLE_READING("ar", AppTypeEnum.ARTICLE_READING.value),
    
    /**
     * 英语随身听
     */
    ENGLISH_WALKMAN("wm", AppTypeEnum.ENGLISH_WALKMAN.value),
    
    /**
     * 口语评测
     */
    ORAL_EVALUATION("speak", AppTypeEnum.ORAL_EVALUATION.value),
    
    /**
     * 绘本故事
     */
    PBSTORY("pbstory", AppTypeEnum.PBSTORY.value),
    
    /**
     * 错题本
     */
    SUBJECTNOTE("subject", AppTypeEnum.SUBJECTNOTE.value),

    /**
     * 点读书
     */
    BOOK_CLICK("clickread", AppTypeEnum.BOOK_CLICK.value),

    /**
     * 冷知识
     */
    COLD_KNOWLEDGE("coldKnowledge", AppTypeEnum.COLD_KNOWLEDGE.value),

    /**
     * flag
     */
    FLAG("flag", AppTypeEnum.FLAG.value),
    /**
     * flag
     */
    CALLIGRAPHY_COPY("calligraphyCopy", AppTypeEnum.CALLIGRAPHY_COPY.value),

    /**
     * 智能背诵
     */
    INTELLECT_RECITE("intellectRecite", AppTypeEnum.INTELLECT_RECITE.value),

    /**
     * 音乐游戏
     */
    MUSIC_GAMES("musicGames", AppTypeEnum.MUSIC_GAMES.value),

    /**
     * 准考证
     */
    TICKET("ticket", AppTypeEnum.TICKET.value);
    
    /**
     * 值
     */
    public final String value;
    
    /**
     * 对应的类型编码
     */
    public String typeCode;
    
    /**
     * 构造
     *
     * @param value
     */
    private AppRouteEnum(String value, String typeCode) {
        this.value = value;
        this.typeCode = typeCode;
    }
    
}
