package com.pcloud.common.enums;

/**
 * @author zhengyongqiang
 * @date 2019/10/23 14:31
 */
public enum BrowserTypeEnum {

    NONE(0,"None"),         // 未知浏览器
    CHROME(1,"Chrome"),     // 谷歌
    IE(2,"IE"),             // IE
    FIREFOX(3,"Firefox"),   // 火狐浏览器
    OPERA(4,"Opera"),       // Opera浏览器
    SAFARI(5,"Safari"),     // 苹果浏览器
    EDGE(6,"Edge"),         // Edge浏览器
    _360SE(7,"360SE"),       // 360安全浏览器
    SE(8,"SE"),             // 搜狗
    THEWORLD(9,"The World"),// 世界之窗
    QQBROWSER(10,"QQBrowser"),// QQ浏览器
    WEIXINBROWSER(11,"WeixinBrowser"), // 微信浏览器
    MAXTHON(12,"Maxthon"),  // 遨游浏览器
    UC(13,"UC");            // UC浏览器


    public final Integer key;
    public final String browserName;

    private BrowserTypeEnum(Integer key, String browserName){
        this.key = key;
        this.browserName = browserName;
    }

    public static Integer getKeyByBrowserName(String browserName) {
        BrowserTypeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            BrowserTypeEnum methodEnum = var1[var3];
            if (methodEnum.browserName.equals(browserName)) {
                return methodEnum.key;
            }
        }
        return NONE.key;
    }

    public static Integer getKeyByUserAgent(String userAgent){
        if(userAgent == null || userAgent.isEmpty()) {return NONE.key;}
        userAgent = userAgent.toLowerCase();
        if(userAgent.contains("opera")){return OPERA.key;}
        if(userAgent.contains("firefox")){return FIREFOX.key;}
        if(userAgent.contains("edge")){return EDGE.key;}
        if(userAgent.contains("qqbrowser") || userAgent.contains("tencenttraveler")){return QQBROWSER.key;}
        if(userAgent.contains("micromessenger")){return WEIXINBROWSER.key;}

        if(userAgent.contains("360se")){return _360SE.key;}
        if(userAgent.contains("se") && userAgent.contains("metasr")){return SE.key;}
        if(userAgent.contains("the world")){return THEWORLD.key;}
        if(userAgent.contains("maxthon")){return MAXTHON.key;}
        if(userAgent.contains("ucweb")){return UC.key;}
        if(userAgent.contains("msie") || (userAgent.contains("trident") && userAgent.contains("rv"))){return IE.key;}

        if(userAgent.contains("chrome") && userAgent.contains("safari")){return CHROME.key;}
        if(userAgent.contains("safari") && !userAgent.contains("chrome")){return SAFARI.key;}

        return NONE.key;
    }
}
