/**
 *
 */
package com.pcloud.common.mq.queue;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.mq.constant.QueueNameConstant;
import com.pcloud.common.mq.dto.ServerLinkDTO;

import lombok.extern.slf4j.Slf4j;

/**
 * @author：songx
 * @date：2019/6/20,11:37
 */
@Slf4j
@Component
public class ServerLinkQueue {
    
    /**
     * 服务调用链路QUEUE
     */
    public static void send(ServerLinkDTO serverLinkDTO) throws BizException {
        log.info("【QUEUE】服务调用链路.[serverLinkDTO]->" + serverLinkDTO);
        if (serverLinkDTO == null) {
            throw BizException.PARAM_IS_NULL;
        }
        getAmqpTemplate().convertAndSend(QueueNameConstant.SERVER_LINK, serverLinkDTO);
    }
    
    /**
     * 获取实例
     *
     * @return
     */
    public static AmqpTemplate getAmqpTemplate() {
        return SingletonInstance.amqpTemplate;
    }
    
    @Component
    public static class SingletonInstance {
        
        private static AmqpTemplate amqpTemplate;
        
        public SingletonInstance(@Autowired AmqpTemplate amqpTemplate) {
            this.amqpTemplate = amqpTemplate;
        }
    }
    
}
