package com.pcloud.common.permission;

import java.io.IOException;

/**
 * @描述：权限异常
 * @作者：shichunshan
 * @创建时间：2016年5月27日,下午2:12:12
 * @版本：1.0
 */
public class PermissionException extends RuntimeException{

	private static final long serialVersionUID = 1336555490029071770L;
	/**
	 * 用户id不存在
	 */	
	public static final PermissionException USER_ID_NOT_FOUND = new PermissionException(600, "用户ID为空");
	/**
	 * 不存在该权限
	 */
	public static final PermissionException PERMISSION_NOT_FOUND = new PermissionException(601, "权限不存在");
	/**
	 * 用户未登录
	 */
	public static final PermissionException PERMISSION_USER_NOT_LOGIN=new PermissionException(602,"用户未登录");
	/**
	 * token过期
	 */
	public static final PermissionException PERMISSION_TOKEN_EXPIRE=new PermissionException(603,"token过期");
	/**
	 * 异常信息
	 */
	protected String msg;

	/**
	 * 具体异常码
	 */
	protected int code;

	public PermissionException(int code, String msgFormat, Object... args) {
		super(String.format(msgFormat, args));
		this.code = code;
		this.msg = String.format(msgFormat, args);
	}

	public PermissionException() {
		super();
	}

	public String getMsg() {
		return msg;
	}

	public int getCode() {
		return code;
	}

	/**
	 * 实例化异常
	 * 
	 * @param msgFormat
	 * @param args
	 * @return
	 */
	public PermissionException newInstance(String msgFormat, Object... args) {
		return new PermissionException(this.code, msgFormat, args);
	}

	public PermissionException(String message, Throwable cause) {
		super(message, cause);
	}

	public PermissionException(Throwable cause) {
		super(cause);
	}

	public PermissionException(String message) {
		super(message);
	}
}
