/**
 * 
 */
package com.pcloud.common.utils;

import org.apache.poi.ss.formula.functions.T;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年2月17日,下午3:22:55
 * @版本：1.0
 */
public class ListUtils {

	public static boolean isEmpty(List<?> list) {
		return (list == null || list.isEmpty());
	}

    private static final Integer OFFSET = 500;

    /**
     * 切割list,默认500长度一个
     * @param list
     * @param <T>
     * @return
     */
    public static <T> List<List<T>> groupList(List<T> list) {
        return groupList(list,OFFSET);
    }

    /**
     * 切割list，自定义长度
     * @param list
     * @param length
     * @param <T>
     * @return
     */
    public static <T> List<List<T>> groupList(List<T> list,int length) {
        List<List<T>> listGroup = new ArrayList<>();
        int listSize = list.size();
        //子集合的长度
        int toIndex = length;
        for (int i = 0; i < list.size(); i += length) {
            if (i + length > listSize) {
                toIndex = listSize - i;
            }
            List<T> newList = list.subList(i, i + toIndex);
            listGroup.add(newList);
        }
        return listGroup;
    }

    /**
     * 切割list，自定义子集合个数
     * @param list
     * @param <T>
     * @return
     */
    public static <T> List<List<T>> groupListBySize(List<T> list,int size) {
        int length = list.size()/size;
        if(list.size()<10){
            length = 1;
        }
        return groupList(list,length);
    }

    public static <T> List<T>groupList4SQL(ListForInSQL<T> listForInSQL,List<Long>idList){
        if(idList==null || idList.size()==0){
            return new ArrayList<>();
        }
        HashSet<Long>idSet = new HashSet<>(idList);
        List<Long>newList = new ArrayList<>();
        newList.addAll(idSet);
        List<T>result = new ArrayList<>();
        if(newList.size()>500){
            List<List<Long>> lists = groupList(newList);
            for (List<Long> list : lists) {
                List<T> tempList = listForInSQL.processSQL(list);
                result.addAll(tempList);
            }
            return result;
        }else if(newList.size()>0){
            return listForInSQL.processSQL(newList);
        }else{
            return new ArrayList<>();
        }

    }


}
