package com.pcloud.common.utils.cache.redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisCluster;

/**
 * 
 */
@Configuration
@EnableCaching
public class JedisClusterConfig {

	public static final String PROPERTIES_NAME = "defaultJedisClusterProperties";
	public static final String JEDIS_CLUSTER_NAME = "defaultJedisCluster";

	@Bean(PROPERTIES_NAME)
	@Primary
	@ConfigurationProperties(prefix = "redis.cluster")
	public JedisClusterProperties defaultJedisClusterProperties() {
		return new JedisClusterProperties();
	}

	/**
	 * JedisCluster
	 */
	@Bean(JEDIS_CLUSTER_NAME)
	@Primary
	public JedisCluster jedisCluster(@Qualifier(PROPERTIES_NAME) JedisClusterProperties properties) {
		GenericObjectPoolConfig<?> config = JedisClusterBeanBuilder.createJedisPoolConfig(properties);

		JedisCluster cluster = JedisClusterBeanBuilder.createJedisCluster(properties, config);

		/*
		 * Important，若是copy，这里请注意是否需要设置
		 */
		JedisClusterUtils.initJedisCluster(cluster);

		return cluster;
	}

}
