package com.pcloud.common.utils.encrypt;

import com.pcloud.common.exceptions.BizException;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;

public class AESUtil {

    private AESUtil() {
    }

    private static final String KEY_AES = "AES";

    private static final String DEFAULT_KEY = "~dcg@rays$2021^&";

    private static Cipher ENCRYPT_CIPHER = null;
    private static Cipher DECRYPT_CIPHER = null;

    /**
     * 使用固定密钥加密
     * @param src   待加密数据
     * @return  加密后数据
     */
    public static String fixedLongEncrypt(final long src) {
        return fixedEncrypt(String.valueOf(src));
    }

    /**
     * 使用固定密钥解密
     * @param encrypted 待解密数据
     * @return  解密后结果
     */
    public static long fixedLongDecrypt(final String encrypted) {
        return Long.parseLong(fixedDecrypt(encrypted));
    }

    /**
     * 使用固定密钥加密
     * @param src   待加密数据
     * @return  加密后数据
     */
    public static String fixedEncrypt(final String src) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        try {
            byte[] encrypted = getEncryptCipherInstance().doFinal(src.getBytes());
            return byte2hex(encrypted);
        } catch (Throwable t) {
            throw new BizException("aes encrypt failed,src=" + src, t);
        }

    }

    /**
     * 使用固定密钥解密
     * @param encrypted 待解密数据
     * @return  解密后结果
     */
    public static String fixedDecrypt(final String encrypted) {
        if (StringUtils.isBlank(encrypted)) {
            return encrypted;
        }
        try {
            byte[] b = hex2byte(encrypted);
            if (b == null) {
                throw new BizException("aes decrypt failed,src=" + encrypted);
            }
            byte[] original = getDecryptCipherInstance().doFinal(b);
            return new String(original, StandardCharsets.UTF_8);
        } catch (Throwable t) {
            throw new BizException("aes decrypt failed,src=" + encrypted, t);
        }
    }

    private static Cipher getEncryptCipherInstance() {
        if (ENCRYPT_CIPHER == null) {
            synchronized (AESUtil.class) {
                if (ENCRYPT_CIPHER == null) {
                    try {
                        byte[] raw = DEFAULT_KEY.getBytes();
                        SecretKeySpec spec = new SecretKeySpec(raw, KEY_AES);
                        ENCRYPT_CIPHER = Cipher.getInstance(KEY_AES);
                        ENCRYPT_CIPHER.init(Cipher.ENCRYPT_MODE, spec);
                    } catch (Throwable t) {
                        ENCRYPT_CIPHER = null;
                        throw new BizException("aes cipher init failed", t);
                    }
                }
            }
        }
        return ENCRYPT_CIPHER;
    }

    private static Cipher getDecryptCipherInstance() {
        if (DECRYPT_CIPHER == null) {
            synchronized (AESUtil.class) {
                if (DECRYPT_CIPHER == null) {
                    try {
                        byte[] raw = DEFAULT_KEY.getBytes();
                        SecretKeySpec spec = new SecretKeySpec(raw, KEY_AES);
                        DECRYPT_CIPHER = Cipher.getInstance(KEY_AES);
                        DECRYPT_CIPHER.init(Cipher.DECRYPT_MODE, spec);
                    } catch (Throwable t) {
                        DECRYPT_CIPHER = null;
                        throw new BizException("aes cipher init failed", t);
                    }
                }
            }
        }
        return DECRYPT_CIPHER;
    }

    private static byte[] hex2byte(String strhex) {
        int l = strhex.length();
        if (l % 2 == 1) {
            return null;
        }
        byte[] b = new byte[l / 2];
        for (int i = 0; i != l / 2; i++) {
            b[i] = (byte) Integer.parseInt(strhex.substring(i * 2, i * 2 + 2),
                    16);
        }
        return b;
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String tmp = "";
        for (byte value : b) {
            tmp = (Integer.toHexString(value & 0XFF));
            if (tmp.length() == 1) {
                hs.append("0").append(tmp);
            } else {
                hs.append(tmp);
            }
        }
        return hs.toString().toUpperCase();
    }

    /**
     * 使用固定密钥加密
     * @param src   待加密数据
     * @return  加密后数据
     */
    public static String fixedEncrypt(final String src,String key) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        if (StringUtils.isBlank(key)) {
            key=DEFAULT_KEY;
        }
        try {
            byte[] encrypted = getEncryptCipherInstance(key).doFinal(src.getBytes());
            return byte2hex(encrypted);
        } catch (Throwable t) {
            throw new BizException("aes encrypt failed,src=" + src, t);
        }
    }

    private static Cipher getEncryptCipherInstance(String key) {
        if (ENCRYPT_CIPHER == null) {
            synchronized (AESUtil.class) {
                if (ENCRYPT_CIPHER == null) {
                    try {
                        byte[] raw = key.getBytes();
                        SecretKeySpec spec = new SecretKeySpec(raw, KEY_AES);
                        ENCRYPT_CIPHER = Cipher.getInstance(KEY_AES);
                        ENCRYPT_CIPHER.init(Cipher.ENCRYPT_MODE, spec);
                    } catch (Throwable t) {
                        ENCRYPT_CIPHER = null;
                        throw new BizException("aes cipher init failed", t);
                    }
                }
            }
        }
        return ENCRYPT_CIPHER;
    }

    public static String fixedDecrypt(final String encrypted,String key) {
        if (StringUtils.isBlank(encrypted)) {
            return encrypted;
        }
        if (StringUtils.isBlank(key)) {
            key=DEFAULT_KEY;
        }
        try {
            byte[] b = hex2byte(encrypted);
            if (b == null) {
                throw new BizException("aes decrypt failed,src=" + encrypted);
            }
            byte[] original = getDecryptCipherInstance(key).doFinal(b);
            return new String(original, StandardCharsets.UTF_8);
        } catch (Throwable t) {
            throw new BizException("aes decrypt failed,src=" + encrypted, t);
        }
    }

    private static Cipher getDecryptCipherInstance(String key) {
        if (DECRYPT_CIPHER == null) {
            synchronized (AESUtil.class) {
                if (DECRYPT_CIPHER == null) {
                    try {
                        byte[] raw = key.getBytes();
                        SecretKeySpec spec = new SecretKeySpec(raw, KEY_AES);
                        DECRYPT_CIPHER = Cipher.getInstance(KEY_AES);
                        DECRYPT_CIPHER.init(Cipher.DECRYPT_MODE, spec);
                    } catch (Throwable t) {
                        DECRYPT_CIPHER = null;
                        throw new BizException("aes cipher init failed", t);
                    }
                }
            }
        }
        return DECRYPT_CIPHER;
    }
}
