package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.ExapiMessageDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

@Component("exapiQueueBiz")
public class ExapiQueueBizImpl implements ExapiQueueBiz{
    private static final Logger LOGGER = LoggerFactory.getLogger(ExapiQueueBiz.class);

    @Autowired(required = false)
    @Qualifier("jmsExapiTemplate")
    private JmsTemplate jmsExapiTemplate;

    @Override
    public void sendMessageQueue(ExapiMessageDto exapiMessageDto) {
        MessageCreator messageCreator = new MessageCreator() {
            @Override
            public ObjectMessage createMessage(Session session) throws JMSException {
                return session.createObjectMessage(exapiMessageDto);
            }
        };

        try {
            jmsExapiTemplate.send(messageCreator);
        } catch (Exception e) {
            LOGGER.error("发送失败，" + e.getMessage() + "," + exapiMessageDto, e);
            throw BizException.SEND_QUEUE_FAIL;
        }
        LOGGER.info("发送成功，" + exapiMessageDto);
    }
}
