package com.pcloud.common.core.biz;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.dto.FundMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @description 基金资源变更记录消息队列实现类
 * @author PENG
 * @date 2017年10月18日 下午2:11:52
 * @version 1.0
 */
@Component("fundQueueBiz")
public class FundQueueBizImpl implements FundQueueBiz {

	/**
	 * logger
	 */
	private final static Logger logger = LoggerFactory.getLogger(FundQueueBizImpl.class);

	@Autowired(required = false)
	@Qualifier("jmsFundTemplate")
	private JmsTemplate jmsFundTemplate;


	/**
	 * 发送队列
	 */
	@Override
	public void sendFundMessage(FundMessageDto fundMessageDto) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(fundMessageDto);
			}
		};

		try {
			jmsFundTemplate.send(messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + fundMessageDto.toString(), e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + fundMessageDto.toString());
	}
}
