package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.PromotionTaskDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

@Service("promotionTaskQueueBiz")
public class PromotionTaskQueueBizImpl implements PromotionTaskQueueBiz {

	/**
	 * 
	 */
	private final static Logger logger = LoggerFactory.getLogger(PromotionTaskQueueBizImpl.class);
	
	/**
	 * 消息模板
	 */
	@Autowired(required = false)
	@Qualifier("jmsPromotionTaskTemplate")
	private JmsTemplate jmsPromotionTaskTemplate;

	@Override
	public void send(PromotionTaskDto promotionTaskDto) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(promotionTaskDto);
			}
		};
		try {
			jmsPromotionTaskTemplate.send(messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + promotionTaskDto, e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + promotionTaskDto);
	}

}
