package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.PromotionTerminateDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

@Service("promotionTerminateQueueBiz")
public class PromotionTerminateQueueBizImpl implements PromotionTerminateQueueBiz {

	/**
	 * 
	 */
	private final static Logger logger = LoggerFactory.getLogger(PromotionTerminateQueueBizImpl.class);
	
	/**
	 * 消息模板
	 */
	@Autowired(required = false)
	@Qualifier("jmsPromotionTerminateTemplate")
	private JmsTemplate jmsPromotionTerminateTemplate;

	@Override
	public void send(PromotionTerminateDto promotionTerminateDto) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(promotionTerminateDto);
			}
		};
		try {
			jmsPromotionTerminateTemplate.send(messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + promotionTerminateDto, e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + promotionTerminateDto);
	}

}
