package com.pcloud.common.core.biz;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.dto.TemplateMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * 
 * @描述：发送模板消息队列实现类
 * @作者：songx
 * @创建时间：2016年11月23日,下午4:53:43 
 * @版本：1.0
 */
@Component("templateQueueBiz")
public class TemplateQueueBizImpl implements TemplateQueueBiz {

	/**
	 * 
	 */
	private final static Logger logger=LoggerFactory.getLogger(TemplateQueueBizImpl.class);
	
	@Autowired(required=false)
	@Qualifier("jmsTemplateTemplate")
	private JmsTemplate jmsTemplateTemplate;

	/**
	 * 发送队列
	 */
	@Override
	public void sendMessageQueue(TemplateMessageDto templateMessageDto) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(templateMessageDto);
			}
		};
		try {
			jmsTemplateTemplate.send(messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + templateMessageDto, e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + templateMessageDto);
	}

}
