package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.WeektaskMessageDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

/**
 * 编辑周任务队列实现
 *
 * @author huanghui
 * @create 2017-09-21 09:33
 **/
@Component("weektaskQueueBiz")
public class WeektaskQueueBizImpl implements WeektaskQueueBiz{

    private final static Logger logger= LoggerFactory.getLogger(WeektaskQueueBizImpl.class);

    @Autowired(required=false)
    @Qualifier("jmsWeektaskTemplate")
    private JmsTemplate jmsWeekstaskTemplate;

//    @Autowired(required=  false)
//    @Qualifier("raystask")
//    private ActiveMQQueue templateQueue;

    /**
     * 发送队列
     */
    @Override
    public void sendMessageQueue(WeektaskMessageDto weektaskMessageDto) throws BizException {
        MessageCreator messageCreator = new MessageCreator() {
            @Override
            public ObjectMessage createMessage(Session session) throws JMSException {
                return session.createObjectMessage(weektaskMessageDto);
            }
        };

        try {
            jmsWeekstaskTemplate.send(messageCreator);
        } catch (Exception e) {
            logger.error("发送失败，" + e.getMessage() + "," + weektaskMessageDto, e);
            throw BizException.SEND_QUEUE_FAIL;
        }
        logger.info("发送成功，" + weektaskMessageDto);
    }

}
