package com.pcloud.common.exceptions;

/**
 * @描述：业务异常基类，所有业务异常都必须继承于此异常 定义异常时，需要先确定异常所属模块。例如：添加企业报错 可以定义为 [10020001]
 *                            前四位数为系统模块编号，后4位为错误代码 ,唯一 <br>
 *                            企业门户异常 1002 <br>
 * 
 * @作者：DiSeng.H
 * @创建时间：2016年3月11日,上午11:10:22 @版本：1.0
 */
public class BizException extends RuntimeException {

	private static final long serialVersionUID = 1335927018262190674L;

	/**
	 * 数据库操作,insert返回0
	 */
	public static final BizException DB_INSERT_RESULT_0 = new BizException(90040001, "数据库操作,insert返回0");

	/**
	 * 数据库操作,update返回0
	 */
	public static final BizException DB_UPDATE_RESULT_0 = new BizException(90040002, "该数据不存在或已被修改，请刷新后重试！");

	/**
	 * 数据库操作,delete返回0
	 */
	public static final BizException DB_DELETE_RESULT_0 = new BizException(90040002, "删除的数据不存在，请刷新后重试！");

	/**
	 * 数据库操作,selectOne返回null
	 */
	public static final BizException DB_SELECTONE_IS_NULL = new BizException(90040003, "数据库操作,selectOne返回null");

	/**
	 * 数据库操作,list返回null
	 */
	public static final BizException DB_LIST_IS_NULL = new BizException(90040004, "数据库操作,list返回null");

	/**
	 * Token 验证不通过
	 */
	public static final BizException TOKEN_IS_ILLICIT = new BizException(90040005, "Token 验证非法");

	/**
	 * 不存在该权限
	 */
	public static final BizException PERMISSION_NOT_FOUND = new BizException(90040005, "权限不存在");

	/**
	 * 会话超时 获取session时，如果是空，throws 下面这个异常 拦截器会拦截爆会话超时页面
	 */
	public static final BizException SESSION_IS_OUT_TIME = new BizException(90040006, "会话超时");

	/**
	 * 获取序列出错
	 */
	public static final BizException DB_GET_SEQ_NEXT_VALUE_ERROR = new BizException(90040007, "获取序列出错");

	/**
	 * Cookie 验证不通过
	 */
	public static final BizException COOKIE_IS_ILLICIT = new BizException(90040005, "Cookie 验证非法");

	/**
	 * 数据库操作,select执行失败
	 */
	public static final BizException DB_SELECT_IS_FAIL = new BizException(90040008, "数据库操作,查询数据失败");

	/**
	 * 发送队列消息失败
	 */
	public static final BizException SEND_QUEUE_FAIL = new BizException(90040009, "发送队列消息失败~！");

	/**
	 * 数据库操作失败
	 */
	public static final BizException DB_DML_FAIL = new BizException(90040010, "服务内部错误，请稍后重试");

	/**
	 * 分页参数缺失
	 */
	public static final BizException PAGE_PARAM_DELETION = new BizException(90040011, "分页参数缺失~！");

	/**
	 * 参数缺失
	 */
	public static final BizException PARAM_DELETION = new BizException(90040012, "参数缺失~！");

	/**
	 * 参数为null
	 */
	public static final BizException PARAM_IS_NULL = new BizException(90040013, "param is null");

	/**
	 * 异常信息
	 */
	protected String msg;

	/**
	 * 具体异常码
	 */
	protected int code;

	public BizException(int code, String msgFormat, Object... args) {
		super(String.format(msgFormat, args));
		this.code = code;
		this.msg = String.format(msgFormat, args);
	}

	public BizException() {
		super();
	}

	public String getMsg() {
		return msg;
	}

	public int getCode() {
		return code;
	}

	/**
	 * 实例化异常
	 * 
	 * @param msgFormat
	 * @param args
	 * @return
	 */
	public BizException newInstance(String msgFormat, Object... args) {
		return new BizException(this.code, msgFormat, args);
	}

	public BizException(String message, Throwable cause) {
		super(message, cause);
	}

	public BizException(Throwable cause) {
		super(cause);
	}

	public BizException(String message) {
		super(message);
	}
}
