package com.pcloud.common.utils;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pcloud.common.page.PageBeanNew;

/**
 * 返回结果工具类
 * 
 * @author：songx
 * @date：2018年8月8日,下午2:09:16
 */
public class ResultUtils {

	/**
	 * 集合查询结果判断
	 * 
	 * @param lists
	 * @return
	 */
	public static <T> List<T> list(List<T> lists) {
		if (!ListUtils.isEmpty(lists)) {
			return lists;
		}
		return Lists.newArrayList();
	}

	/**
	 * map查询结果判断
	 * 
	 * @param lists
	 * @return
	 */
	public static <K, V> Map<K, V> map(Map<K, V> map) {
		if (!MapUtils.isEmpty(map)) {
			return map;
		}
		return Maps.newHashMap();
	}

	/**
	 * 分页查询结果判断
	 * 
	 * @param pageBeanNew
	 * @return
	 */
	public static <T> PageBeanNew<T> pageBeanNew(PageBeanNew<T> pageBeanNew, Integer currentPage, Integer numPerPage) {
		if (pageBeanNew != null) {
			return pageBeanNew;
		}
		return new PageBeanNew<T>(currentPage, numPerPage, 0, Lists.newArrayList());
	}

}
