package com.pcloud.book.guide.service;

import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "pcloudRobotWakeUpServiceCloud", path = "book/v1.0/pcloudRobotWakeUpService")
@Api(description = "机器人自动唤醒内部服务")
public interface PcloudRobotWakeUpService {

    @ApiOperation("定时任务")
    @PostMapping("/doJob")
    void doJob(@RequestBody Map<String, Object> map)throws BizException;
}
