package com.pcloud.book.rightsSetting.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.cultivate.enums.ReadTypeEnum;
import com.pcloud.book.rightsSetting.constants.RightsSettingConstant;
import com.pcloud.book.rightsSetting.entity.RightsItemGroup;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.book.rightsSetting.entity.RightsSettingTitle;
import com.pcloud.book.rightsSetting.enums.RightsNowItemTypeNew;
import com.pcloud.book.rightsSetting.enums.RightsTypeEnum;
import com.pcloud.book.rightsSetting.enums.RightsWeekTypeEnum;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import java.util.Collections;
import java.util.Map.Entry;
import org.apache.commons.collections.MapUtils;
import org.apache.lucene.analysis.util.CharArrayMap.EntrySet;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

@Component("权益设置参数校验")
@Slf4j
public class RightsSettingCheck {

    public void rightsSettingCheck(RightsSetting rightsSetting) {
        log.info("更新权益设置参数校验");
        if (null == rightsSetting){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (RightsTypeEnum.BASE.code.equals(rightsSetting.getStepType())){
            if (null==rightsSetting.getRightsSettingType()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"权益类型为空！");
            }
            if (rightsSetting.getRightsSettingType() == 2 &&ListUtils.isEmpty(rightsSetting.getRightsSettingBookRelations())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"RightsSettingBookRelations不能为空！");
            }
            if (rightsSetting.getRightsSettingType()==1 && null == rightsSetting.getFirstClassify()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"分类为空！");
            }
        }
        if (RightsTypeEnum.NOW.code.equals(rightsSetting.getStepType())){
            checkRightNowItem(rightsSetting);
            checkRightItemGroups(rightsSetting);
        } else if (RightsTypeEnum.WEEK.code.equals(rightsSetting.getStepType())){
            checkRightItem(rightsSetting.getRightsSettingWeekItems());
        } else if (RightsTypeEnum.LONG_TERM.code.equals(rightsSetting.getStepType())){
            checkRightItem(rightsSetting.getRightsSettingLongTermItems());
        }
    }

    private void checkRightItem(List<RightsSettingItem> list) {
        if (ListUtils.isEmpty(list)) {
            return;
        }
        Map<Long, List<RightsSettingItem>> listMap = list.stream().collect(Collectors.groupingBy(RightsSettingItem::getRightsClassifyId));
        for (Map.Entry<Long, List<RightsSettingItem>> entry : listMap.entrySet()) {
            List<RightsSettingItem> items = entry.getValue();
            if (items.size() > 1) {
                int easyReadCount = 0;
                int efficientReadCount = 0;
                int deepReadCount = 0;
                for (RightsSettingItem item : items) {
                    if (null != item.getEasyRead() && item.getEasyRead()) {
                        ++easyReadCount;
                    }
                    if (null != item.getEfficientRead() && item.getEfficientRead()) {
                        ++efficientReadCount;
                    }
                    if (null != item.getDeepRead() && item.getDeepRead()) {
                        ++deepReadCount;
                    }
                }
                Integer typeId = items.get(0).getRightsClassifyId().intValue();
                if (easyReadCount > 1 || efficientReadCount > 1 || deepReadCount > 1) {
                    throw new BookBizException(BookBizException.PARAM_IS_NULL, "查询到对应的权益分类阅读方式有重复配置，请修改权益分类："+RightsWeekTypeEnum.getValue(typeId));
                }
            }
        }
    }


    private void checkRightItemGroups(RightsSetting rightsSetting) {
        if (rightsSetting==null||ListUtils.isEmpty(rightsSetting.getRightsItemGroups())){
            return;
        }
        for (RightsItemGroup group: rightsSetting.getRightsItemGroups()){
            if (group.getShowState()==null){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "分组是否显示为空！");
            }
            if (group.getType()==null){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "分组类型为空为空！");
            }
            if (StringUtil.isEmpty(group.getName())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "分组名称为空！");
            }
            if (!ListUtils.isEmpty(group.getRightsNowItems())){
                checkRightNowItemApp(group.getRightsNowItems());
            }
        }
    }

    private void checkRightNowItem(RightsSetting rightsSetting) {
        if (rightsSetting == null) {
            return;
        }
        if (null != rightsSetting.getOnlineRightsSettingTitle()) {
            checkRightNowItemApp(rightsSetting.getOnlineRightsSettingTitle().getRightsSettingItemList());
        }
        if (null != rightsSetting.getLearningToolTitle()) {
            checkRightNowItemApp(rightsSetting.getLearningToolTitle().getRightsSettingItemList());
        }
        if (null != rightsSetting.getDrawSettingTitle()) {
            checkRightNowItemApp(rightsSetting.getDrawSettingTitle().getRightsSettingItemList());
        }
        if (null != rightsSetting.getGiftCouponPackageTitle() && !ListUtils.isEmpty(rightsSetting.getGiftCouponPackageTitle().getRightsSettingItemList())) {
            for (RightsNowItem item : rightsSetting.getGiftCouponPackageTitle().getRightsSettingItemList()) {
                if (item.getGiftCouponPackageId() == null) {
                    throw new BookBizException(BookBizException.PARAM_IS_NULL, "专享礼包券id为空！");
                }
            }
        }
    }

    public void checkRightNowItemApp(List<RightsNowItem> items) {
        if (ListUtils.isEmpty(items)){
            return;
        }
        for (RightsNowItem item : items) {
            if (RightsNowItemTypeNew.GIFT_COUPON_PACKAGE.value.equals(item.getType())){
                continue;
            }
            if (item.getServeId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "作品或应用id为空！");
            }
            if (StringUtil.isEmpty(item.getServeType())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "作品或应用类型为空！");
            }
            if (("APP".equals(item.getServeType()) || "PRODUCT".equals(item.getServeType())) && StringUtil.isEmpty(item.getLinkUrl())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "作品或应用链接为空！");
            }
        }
    }

    public void checkRightNowItems(List<RightsNowItem> items) {
        if (ListUtils.isEmpty(items)) {
            return;
        }
        this.checkRightNowItemApp(items);
    }

    public void checkRightNowTitles(List<RightsSettingTitle> rightsSettingTitleList) {
        if (ListUtils.isEmpty(rightsSettingTitleList)) {
            return;
        }
        Map<Integer, List<RightsSettingTitle>> titleMap =
                rightsSettingTitleList.stream().collect(Collectors.groupingBy(RightsSettingTitle::getRightsSettingNowType));
        if (MapUtils.isEmpty(titleMap)) {
            return;
        }
        for (List<RightsSettingTitle> rightsSettingTitles : titleMap.values()) {
            if (ListUtils.isEmpty(rightsSettingTitles)) {
                continue;
            }
            if (rightsSettingTitles.size() > RightsSettingConstant.MAX_ITEM_COUNT) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "单种类型的权限不可超过3个");
            }
            int easyReadCount = 0;
            int efficientReadCount = 0;
            int deepReadCount = 0;
            for (RightsSettingTitle rightsSettingTitle : rightsSettingTitles) {
                if (null != rightsSettingTitle.getEasyRead() && rightsSettingTitle.getEasyRead()) {
                    ++easyReadCount;
                }
                if (null != rightsSettingTitle.getEfficientRead() && rightsSettingTitle.getEfficientRead()) {
                    ++efficientReadCount;
                }
                if (null != rightsSettingTitle.getDeepRead() && rightsSettingTitle.getDeepRead()) {
                    ++deepReadCount;
                }
            }
            if (easyReadCount > 1 || efficientReadCount > 1 || deepReadCount > 1) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "查询到对应的权益阅读方式有重复配置，请修改权益");
            }
        }
    }

    public void rightsSettingCheck4Insert(RightsSetting rightsSetting) {
        log.info("新增权益设置参数校验");
        if (null == rightsSetting) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数为空！");
        }
        if (null == rightsSetting.getRightsSettingType()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "权益类型为空！");
        }
        if (rightsSetting.getRightsSettingType() == 2 && ListUtils.isEmpty(rightsSetting.getRightsSettingBookRelations())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "RightsSettingBookRelations不能为空！");
        }
        if (rightsSetting.getRightsSettingType() == 1 && null == rightsSetting.getFirstClassify()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "分类为空！");
        }
    }
}
